/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.util.Bits;

public class ValueSourceFilter
extends Filter {
    final Filter startingFilter;
    final ValueSource source;
    final double min;
    final double max;

    public ValueSourceFilter(Filter startingFilter, ValueSource source2, double min2, double max2) {
        if (startingFilter == null) {
            throw new IllegalArgumentException("please provide a non-null startingFilter; you can use QueryWrapperFilter(MatchAllDocsQuery) as a no-op filter");
        }
        this.startingFilter = startingFilter;
        this.source = source2;
        this.min = min2;
        this.max = max2;
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        final FunctionValues values = this.source.getValues(null, context);
        return new FilteredDocIdSet(this.startingFilter.getDocIdSet(context, acceptDocs)){

            @Override
            public boolean match(int doc2) {
                double val2 = values.doubleVal(doc2);
                return val2 >= ValueSourceFilter.this.min && val2 <= ValueSourceFilter.this.max;
            }
        };
    }

    @Override
    public String toString(String field) {
        return "ValueSourceFilter(startingFilter=" + this.startingFilter.toString(field) + "," + "source=" + this.source.toString() + "," + "min=" + this.min + "," + "max=" + this.max + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ValueSourceFilter other = (ValueSourceFilter)obj;
        return this.startingFilter.equals(other.startingFilter) && this.source.equals(other.source) && this.min == this.min && this.max == this.max;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startingFilter, this.source, this.min, this.max);
    }
}

