/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class Plane
extends Vector {
    protected static final GeoPoint[] NO_POINTS = new GeoPoint[0];
    protected static final Membership[] NO_BOUNDS = new Membership[0];
    public final double D;

    public Plane(double A, double B, double C2, double D2) {
        super(A, B, C2);
        this.D = D2;
    }

    public Plane(Vector A, Vector B) {
        super(A, B);
        this.D = 0.0;
    }

    public Plane(double height) {
        super(0.0, 0.0, 1.0);
        this.D = -height;
    }

    public Plane(double x, double y) {
        super(y, -x, 0.0);
        this.D = 0.0;
    }

    public Plane(Vector v, double D2) {
        super(v.x, v.y, v.z);
        this.D = D2;
    }

    public double evaluate(Vector v) {
        return this.dotProduct(v) + this.D;
    }

    public double evaluate(double x, double y, double z) {
        return this.dotProduct(x, y, z) + this.D;
    }

    public boolean evaluateIsZero(Vector v) {
        return Math.abs(this.evaluate(v)) < 1.0E-12;
    }

    public boolean evaluateIsZero(double x, double y, double z) {
        return Math.abs(this.evaluate(x, y, z)) < 1.0E-12;
    }

    @Override
    public Plane normalize() {
        Vector normVect = super.normalize();
        if (normVect == null) {
            return null;
        }
        return new Plane(normVect, this.D);
    }

    public GeoPoint[] interpolate(GeoPoint start, GeoPoint end, double[] proportions) {
        double beginAngle;
        double delta;
        double newEndAngle;
        double cosHA;
        double sinHA;
        double sinRA;
        double cosRA;
        double A = this.x;
        double B = this.y;
        double C2 = this.z;
        double transX = -this.D * A;
        double transY = -this.D * B;
        double transZ = -this.D * C2;
        double magnitude = this.magnitude();
        if (magnitude >= 1.0E-12) {
            double denom = 1.0 / magnitude;
            A *= denom;
            B *= denom;
            C2 *= denom;
            double xyMagnitude = Math.sqrt(A * A + B * B);
            if (xyMagnitude >= 1.0E-12) {
                double xyDenom = 1.0 / xyMagnitude;
                cosRA = A * xyDenom;
                sinRA = -B * xyDenom;
            } else {
                cosRA = 1.0;
                sinRA = 0.0;
            }
            sinHA = xyMagnitude;
            cosHA = C2;
        } else {
            cosRA = 1.0;
            sinRA = 0.0;
            cosHA = 1.0;
            sinHA = 0.0;
        }
        Vector modifiedStart = Plane.modify(start, transX, transY, transZ, sinRA, cosRA, sinHA, cosHA);
        Vector modifiedEnd = Plane.modify(end, transX, transY, transZ, sinRA, cosRA, sinHA, cosHA);
        if (Math.abs(modifiedStart.z) >= 1.0E-12) {
            throw new IllegalArgumentException("Start point was not on plane: " + modifiedStart.z);
        }
        if (Math.abs(modifiedEnd.z) >= 1.0E-12) {
            throw new IllegalArgumentException("End point was not on plane: " + modifiedEnd.z);
        }
        double startAngle = Math.atan2(modifiedStart.y, modifiedStart.x);
        double endAngle = Math.atan2(modifiedEnd.y, modifiedEnd.x);
        double startMagnitude = Math.sqrt(modifiedStart.x * modifiedStart.x + modifiedStart.y * modifiedStart.y);
        for (newEndAngle = endAngle; newEndAngle < startAngle; newEndAngle += Math.PI * 2) {
        }
        if (newEndAngle - startAngle <= Math.PI) {
            delta = newEndAngle - startAngle;
            beginAngle = startAngle;
        } else {
            double newStartAngle;
            for (newStartAngle = startAngle; newStartAngle < endAngle; newStartAngle += Math.PI * 2) {
            }
            delta = newStartAngle - endAngle;
            beginAngle = endAngle;
        }
        GeoPoint[] returnValues = new GeoPoint[proportions.length];
        for (int i = 0; i < returnValues.length; ++i) {
            double newAngle = startAngle + proportions[i] * delta;
            double sinNewAngle = Math.sin(newAngle);
            double cosNewAngle = Math.cos(newAngle);
            Vector newVector = new Vector(cosNewAngle * startMagnitude, sinNewAngle * startMagnitude, 0.0);
            returnValues[i] = Plane.reverseModify(newVector, transX, transY, transZ, sinRA, cosRA, sinHA, cosHA);
        }
        return returnValues;
    }

    protected static Vector modify(GeoPoint start, double transX, double transY, double transZ, double sinRA, double cosRA, double sinHA, double cosHA) {
        return start.translate(transX, transY, transZ).rotateXY(sinRA, cosRA).rotateXZ(sinHA, cosHA);
    }

    protected static GeoPoint reverseModify(Vector point, double transX, double transY, double transZ, double sinRA, double cosRA, double sinHA, double cosHA) {
        Vector result = point.rotateXZ(-sinHA, cosHA).rotateXY(-sinRA, cosRA).translate(-transX, -transY, -transZ);
        return new GeoPoint(result.x, result.y, result.z);
    }

    protected GeoPoint[] findIntersections(Plane q, Membership[] bounds, Membership[] moreBounds) {
        double z0;
        double y0;
        double x0;
        double denom;
        Vector lineVector = new Vector(this, q);
        if (Math.abs(lineVector.x) < 1.0E-12 && Math.abs(lineVector.y) < 1.0E-12 && Math.abs(lineVector.z) < 1.0E-12) {
            return NO_POINTS;
        }
        double denomYZ = this.y * q.z - this.z * q.y;
        double denomXZ = this.x * q.z - this.z * q.x;
        double denomXY = this.x * q.y - this.y * q.x;
        if (Math.abs(denomYZ) >= Math.abs(denomXZ) && Math.abs(denomYZ) >= Math.abs(denomXY)) {
            if (Math.abs(denomYZ) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomYZ;
            x0 = 0.0;
            y0 = (-this.D * q.z - this.z * -q.D) * denom;
            z0 = (this.y * -q.D + this.D * q.y) * denom;
        } else if (Math.abs(denomXZ) >= Math.abs(denomXY) && Math.abs(denomXZ) >= Math.abs(denomYZ)) {
            if (Math.abs(denomXZ) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomXZ;
            x0 = (-this.D * q.z - this.z * -q.D) * denom;
            y0 = 0.0;
            z0 = (this.x * -q.D + this.D * q.x) * denom;
        } else {
            if (Math.abs(denomXY) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomXY;
            x0 = (-this.D * q.y - this.y * -q.D) * denom;
            y0 = (this.x * -q.D + this.D * q.x) * denom;
            z0 = 0.0;
        }
        double A = lineVector.x * lineVector.x + lineVector.y * lineVector.y + lineVector.z * lineVector.z;
        double B = 2.0 * (lineVector.x * x0 + lineVector.y * y0 + lineVector.z * z0);
        double C2 = x0 * x0 + y0 * y0 + z0 * z0 - 1.0;
        double BsquaredMinus = B * B - 4.0 * A * C2;
        if (Math.abs(BsquaredMinus) < 1.0E-24) {
            double inverse2A = 1.0 / (2.0 * A);
            double t = -B * inverse2A;
            GeoPoint point = new GeoPoint(lineVector.x * t + x0, lineVector.y * t + y0, lineVector.z * t + z0);
            if (point.isWithin(bounds, moreBounds)) {
                return new GeoPoint[]{point};
            }
            return NO_POINTS;
        }
        if (BsquaredMinus > 0.0) {
            double inverse2A = 1.0 / (2.0 * A);
            double sqrtTerm = Math.sqrt(BsquaredMinus);
            double t1 = (-B + sqrtTerm) * inverse2A;
            double t2 = (-B - sqrtTerm) * inverse2A;
            GeoPoint point1 = new GeoPoint(lineVector.x * t1 + x0, lineVector.y * t1 + y0, lineVector.z * t1 + z0);
            GeoPoint point2 = new GeoPoint(lineVector.x * t2 + x0, lineVector.y * t2 + y0, lineVector.z * t2 + z0);
            if (point1.isWithin(bounds, moreBounds)) {
                if (point2.isWithin(bounds, moreBounds)) {
                    return new GeoPoint[]{point1, point2};
                }
                return new GeoPoint[]{point1};
            }
            if (point2.isWithin(bounds, moreBounds)) {
                return new GeoPoint[]{point2};
            }
            return NO_POINTS;
        }
        return NO_POINTS;
    }

    public void recordBounds(Plane q, Bounds boundsInfo, Membership ... bounds) {
        GeoPoint[] intersectionPoints;
        for (GeoPoint intersectionPoint : intersectionPoints = this.findIntersections(q, bounds, NO_BOUNDS)) {
            boundsInfo.addPoint(intersectionPoint);
        }
    }

    public void recordBounds(Bounds boundsInfo, Membership ... bounds) {
        double A = this.x;
        double B = this.y;
        double C2 = this.z;
        if (!boundsInfo.checkNoTopLatitudeBound() || !boundsInfo.checkNoBottomLatitudeBound()) {
            if (Math.abs(A) >= 1.0E-12 || Math.abs(B) >= 1.0E-12) {
                double x;
                double y;
                double z;
                double denom;
                if (Math.abs(C2) < 1.0E-12) {
                    denom = 1.0 / (A * A + B * B);
                    z = Math.sqrt(1.0 - this.D * this.D);
                    y = -B * this.D * denom;
                    x = -A * this.D * denom;
                    Plane.addPoint(boundsInfo, bounds, x, y, z);
                    z = -z;
                    Plane.addPoint(boundsInfo, bounds, x, y, z);
                } else if (Math.abs(this.D) < 1.0E-12) {
                    denom = 1.0 / (A * A + B * B);
                    z = Math.sqrt((A * A + B * B) / (A * A + B * B + C2 * C2));
                    y = -B * (C2 * z) * denom;
                    x = -A * (C2 * z) * denom;
                    Plane.addPoint(boundsInfo, bounds, x, y, z);
                    z = -z;
                    y = -B * (C2 * z) * denom;
                    x = -A * (C2 * z) * denom;
                    Plane.addPoint(boundsInfo, bounds, x, y, z);
                } else {
                    double sqrtValue = this.D * this.D * C2 * C2 + 1.0 - C2 * C2 - this.D * this.D;
                    double denom2 = 1.0 / (A * A + B * B);
                    if (Math.abs(sqrtValue) < 1.0E-24) {
                        z = this.D * C2;
                        double insideValue = A * A + B * B - this.D * this.D - z * z - 2.0 * C2 * this.D * z;
                        if (Math.abs(insideValue) < 1.0E-12 && this.evaluateIsZero(x = -A * (this.D + C2 * z) * denom2, y = -B * (this.D + C2 * z) * denom2, z)) {
                            Plane.addPoint(boundsInfo, bounds, x, y, z);
                        }
                        if (Math.abs(insideValue = A * A + B * B - this.D * this.D - (z = -z) * z - 2.0 * C2 * this.D * z) < 1.0E-12 && this.evaluateIsZero(x = -A * (this.D + C2 * z) * denom2, y = -B * (this.D + C2 * z) * denom2, z)) {
                            Plane.addPoint(boundsInfo, bounds, x, y, z);
                        }
                    } else if (sqrtValue > 0.0) {
                        double sqrtResult = Math.sqrt(sqrtValue);
                        z = this.D * C2 + sqrtResult;
                        double insideValue = A * A + B * B - this.D * this.D - z * z - 2.0 * C2 * this.D * z;
                        if (Math.abs(insideValue) < 1.0E-12 && this.evaluateIsZero(x = -A * (this.D + C2 * z) * denom2, y = -B * (this.D + C2 * z) * denom2, z)) {
                            Plane.addPoint(boundsInfo, bounds, x, y, z);
                        }
                        if (Math.abs(insideValue = A * A + B * B - this.D * this.D - (z = -z) * z - 2.0 * C2 * this.D * z) < 1.0E-12 && this.evaluateIsZero(x = -A * (this.D + C2 * z) * denom2, y = -B * (this.D + C2 * z) * denom2, z)) {
                            Plane.addPoint(boundsInfo, bounds, x, y, z);
                        }
                        if (Math.abs(insideValue = A * A + B * B - this.D * this.D - (z = this.D * C2 - sqrtResult) * z - 2.0 * C2 * this.D * z) < 1.0E-12 && this.evaluateIsZero(x = -A * (this.D + C2 * z) * denom2, y = -B * (this.D + C2 * z) * denom2, z)) {
                            Plane.addPoint(boundsInfo, bounds, x, y, z);
                        }
                        if (Math.abs(insideValue = A * A + B * B - this.D * this.D - (z = -z) * z - 2.0 * C2 * this.D * z) < 1.0E-12 && this.evaluateIsZero(x = -A * (this.D + C2 * z) * denom2, y = -B * (this.D + C2 * z) * denom2, z)) {
                            Plane.addPoint(boundsInfo, bounds, x, y, z);
                        }
                    }
                }
            } else {
                boundsInfo.addHorizontalCircle(-this.D * C2);
            }
        }
        if (!boundsInfo.checkNoLongitudeBound()) {
            double c;
            double a;
            double b;
            if (Math.abs(C2) < 1.0E-12) {
                if (Math.abs(this.D) >= 1.0E-12) {
                    double denom;
                    double sqrtResult;
                    double z0;
                    double sqrtClause;
                    if (Math.abs(A) > Math.abs(B)) {
                        b = 2.0 * B * this.D;
                        a = B * B + A * A;
                        c = this.D * this.D - A * A;
                        sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-24) {
                            double y0 = -b / (2.0 * a);
                            double x0 = (-this.D - B * y0) / A;
                            z0 = 0.0;
                            Plane.addPoint(boundsInfo, bounds, x0, y0, z0);
                        } else if (sqrtClause > 0.0) {
                            sqrtResult = Math.sqrt(sqrtClause);
                            denom = 1.0 / (2.0 * a);
                            double Hdenom = 1.0 / A;
                            double y0a = (-b + sqrtResult) * denom;
                            double y0b = (-b - sqrtResult) * denom;
                            double x0a = (-this.D - B * y0a) * Hdenom;
                            double x0b = (-this.D - B * y0b) * Hdenom;
                            double z0a = 0.0;
                            double z0b = 0.0;
                            Plane.addPoint(boundsInfo, bounds, x0a, y0a, z0a);
                            Plane.addPoint(boundsInfo, bounds, x0b, y0b, z0b);
                        }
                    } else {
                        b = 2.0 * A * this.D;
                        a = B * B + A * A;
                        c = this.D * this.D - B * B;
                        sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-24) {
                            double x0 = -b / (2.0 * a);
                            double y0 = (-this.D - A * x0) / B;
                            z0 = 0.0;
                            Plane.addPoint(boundsInfo, bounds, x0, y0, z0);
                        } else if (sqrtClause > 0.0) {
                            sqrtResult = Math.sqrt(sqrtClause);
                            denom = 1.0 / (2.0 * a);
                            double Idenom = 1.0 / B;
                            double x0a = (-b + sqrtResult) * denom;
                            double x0b = (-b - sqrtResult) * denom;
                            double y0a = (-this.D - A * x0a) * Idenom;
                            double y0b = (-this.D - A * x0b) * Idenom;
                            double z0a = 0.0;
                            double z0b = 0.0;
                            Plane.addPoint(boundsInfo, bounds, x0a, y0a, z0a);
                            Plane.addPoint(boundsInfo, bounds, x0b, y0b, z0b);
                        }
                    }
                }
            } else {
                double E = A * A + C2 * C2;
                double F = B * B + C2 * C2;
                double G = 2.0 * A * B;
                double H = 2.0 * A * this.D;
                double I = 2.0 * B * this.D;
                double J = this.D * this.D - C2 * C2;
                if (Math.abs(J) >= 1.0E-12 && J > 0.0) {
                    if (Math.abs(H) > Math.abs(I)) {
                        b = 4.0 * E * I * J - 2.0 * G * H * J;
                        a = E * I * I - G * H * I + F * H * H;
                        c = 4.0 * E * J * J - J * H * H;
                        double sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-36) {
                            double y0 = -b / (2.0 * a);
                            double x0 = (-2.0 * J - I * y0) / H;
                            double z0 = (-A * x0 - B * y0 - this.D) / C2;
                            Plane.addPoint(boundsInfo, bounds, x0, y0, z0);
                        } else if (sqrtClause > 0.0) {
                            double sqrtResult = Math.sqrt(sqrtClause);
                            double denom = 1.0 / (2.0 * a);
                            double Hdenom = 1.0 / H;
                            double Cdenom = 1.0 / C2;
                            double y0a = (-b + sqrtResult) * denom;
                            double y0b = (-b - sqrtResult) * denom;
                            double x0a = (-2.0 * J - I * y0a) * Hdenom;
                            double x0b = (-2.0 * J - I * y0b) * Hdenom;
                            double z0a = (-A * x0a - B * y0a - this.D) * Cdenom;
                            double z0b = (-A * x0b - B * y0b - this.D) * Cdenom;
                            Plane.addPoint(boundsInfo, bounds, x0a, y0a, z0a);
                            Plane.addPoint(boundsInfo, bounds, x0b, y0b, z0b);
                        }
                    } else {
                        b = 4.0 * F * H * J - 2.0 * G * I * J;
                        a = E * I * I - G * H * I + F * H * H;
                        c = 4.0 * F * J * J - J * I * I;
                        double sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-36) {
                            double x0 = -b / (2.0 * a);
                            double y0 = (-2.0 * J - H * x0) / I;
                            double z0 = (-A * x0 - B * y0 - this.D) / C2;
                            Plane.addPoint(boundsInfo, bounds, x0, y0, z0);
                        } else if (sqrtClause > 0.0) {
                            double sqrtResult = Math.sqrt(sqrtClause);
                            double denom = 1.0 / (2.0 * a);
                            double Idenom = 1.0 / I;
                            double Cdenom = 1.0 / C2;
                            double x0a = (-b + sqrtResult) * denom;
                            double x0b = (-b - sqrtResult) * denom;
                            double y0a = (-2.0 * J - H * x0a) * Idenom;
                            double y0b = (-2.0 * J - H * x0b) * Idenom;
                            double z0a = (-A * x0a - B * y0a - this.D) * Cdenom;
                            double z0b = (-A * x0b - B * y0b - this.D) * Cdenom;
                            Plane.addPoint(boundsInfo, bounds, x0a, y0a, z0a);
                            Plane.addPoint(boundsInfo, bounds, x0b, y0b, z0b);
                        }
                    }
                }
            }
        }
    }

    protected static void addPoint(Bounds boundsInfo, Membership[] bounds, double x, double y, double z) {
        for (Membership bound : bounds) {
            if (bound.isWithin(x, y, z)) continue;
            return;
        }
        boundsInfo.addPoint(x, y, z);
    }

    public boolean intersects(Plane q, GeoPoint[] notablePoints, GeoPoint[] moreNotablePoints, Membership[] bounds, Membership ... moreBounds) {
        if (this.isNumericallyIdentical(q)) {
            for (GeoPoint p : notablePoints) {
                if (!Plane.meetsAllBounds(p, bounds, moreBounds)) continue;
                return true;
            }
            for (GeoPoint p : moreNotablePoints) {
                if (!Plane.meetsAllBounds(p, bounds, moreBounds)) continue;
                return true;
            }
            return false;
        }
        return this.findIntersections(q, bounds, moreBounds).length > 0;
    }

    protected boolean isNumericallyIdentical(Plane p) {
        if (Math.abs(this.y * p.z - this.z * p.y) >= 1.0E-12) {
            return false;
        }
        if (Math.abs(this.z * p.x - this.x * p.z) >= 1.0E-12) {
            return false;
        }
        if (Math.abs(this.x * p.y - this.y * p.x) >= 1.0E-12) {
            return false;
        }
        double denom = 1.0 / (p.x * p.x + p.y * p.y + p.z * p.z);
        return this.evaluateIsZero(-p.x * p.D * denom, -p.y * p.D * denom, -p.z * p.D * denom);
    }

    protected static boolean meetsAllBounds(GeoPoint p, Membership[] bounds, Membership[] moreBounds) {
        for (Membership bound : bounds) {
            if (bound.isWithin(p)) continue;
            return false;
        }
        for (Membership bound : moreBounds) {
            if (bound.isWithin(p)) continue;
            return false;
        }
        return true;
    }

    public GeoPoint getSampleIntersectionPoint(Plane q) {
        GeoPoint[] intersections = this.findIntersections(q, NO_BOUNDS, NO_BOUNDS);
        if (intersections.length == 0) {
            return null;
        }
        return intersections[0];
    }

    @Override
    public String toString() {
        return "[A=" + this.x + ", B=" + this.y + "; C=" + this.z + "; D=" + this.D + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof Plane)) {
            return false;
        }
        Plane other = (Plane)o;
        return other.D == this.D;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.D);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

