/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBox;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxBase;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxFactory;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoShape;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.SidedPlane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoDegenerateLongitudeSlice
extends GeoBBoxBase {
    public final double longitude;
    public final double sinLongitude;
    public final double cosLongitude;
    public final SidedPlane boundingPlane;
    public final Plane plane;
    public final GeoPoint interiorPoint;
    public final GeoPoint[] edgePoints;
    public static final GeoPoint[] planePoints = new GeoPoint[]{NORTH_POLE, SOUTH_POLE};

    public GeoDegenerateLongitudeSlice(double longitude) {
        if (longitude < -Math.PI || longitude > Math.PI) {
            throw new IllegalArgumentException("Longitude out of range");
        }
        this.longitude = longitude;
        this.sinLongitude = Math.sin(longitude);
        this.cosLongitude = Math.cos(longitude);
        this.plane = new Plane(this.cosLongitude, this.sinLongitude);
        this.interiorPoint = new GeoPoint(this.cosLongitude, this.sinLongitude, 0.0);
        this.boundingPlane = new SidedPlane((Vector)this.interiorPoint, -this.sinLongitude, this.cosLongitude);
        this.edgePoints = new GeoPoint[]{this.interiorPoint};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newLeftLon = this.longitude - angle;
        double newRightLon = this.longitude + angle;
        double currentLonSpan = 2.0 * angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(1.5707963267948966, -1.5707963267948966, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.plane.evaluateIsZero(point) && this.boundingPlane.isWithin(point);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.plane.evaluateIsZero(x, y, z) && this.boundingPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        return 1.5707963267948966;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.plane, notablePoints, planePoints, bounds, this.boundingPlane);
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        bounds.noTopLatitudeBound().noBottomLatitudeBound();
        bounds.addLongitudeSlice(this.longitude, this.longitude);
        return bounds;
    }

    @Override
    public int getRelationship(GeoShape path2) {
        if (path2.intersects(this.plane, planePoints, this.boundingPlane)) {
            return 2;
        }
        if (path2.isWithin(this.interiorPoint)) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegenerateLongitudeSlice)) {
            return false;
        }
        GeoDegenerateLongitudeSlice other = (GeoDegenerateLongitudeSlice)o;
        return other.longitude == this.longitude;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.longitude);
        int result = (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoDegenerateLongitudeSlice: {longitude=" + this.longitude + "(" + this.longitude * 180.0 / Math.PI + ")}";
    }
}

