/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SmallFloat;

public class BM25Similarity
extends Similarity {
    private final float k1;
    private final float b;
    protected boolean discountOverlaps = true;
    private static final float[] NORM_TABLE = new float[256];

    public BM25Similarity(float k1, float b) {
        this.k1 = k1;
        this.b = b;
    }

    public BM25Similarity() {
        this.k1 = 1.2f;
        this.b = 0.75f;
    }

    protected float idf(long docFreq, long numDocs) {
        return (float)Math.log(1.0 + ((double)(numDocs - docFreq) + 0.5) / ((double)docFreq + 0.5));
    }

    protected float sloppyFreq(int distance) {
        return 1.0f / (float)(distance + 1);
    }

    protected float scorePayload(int doc2, int start, int end, BytesRef payload) {
        return 1.0f;
    }

    protected float avgFieldLength(CollectionStatistics collectionStats) {
        long sumTotalTermFreq = collectionStats.sumTotalTermFreq();
        if (sumTotalTermFreq <= 0L) {
            return 1.0f;
        }
        return (float)((double)sumTotalTermFreq / (double)collectionStats.maxDoc());
    }

    protected byte encodeNormValue(float boost, int fieldLength) {
        return SmallFloat.floatToByte315(boost / (float)Math.sqrt(fieldLength));
    }

    protected float decodeNormValue(byte b) {
        return NORM_TABLE[b & 0xFF];
    }

    public void setDiscountOverlaps(boolean v) {
        this.discountOverlaps = v;
    }

    public boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }

    @Override
    public final long computeNorm(FieldInvertState state) {
        int numTerms = this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength();
        return this.encodeNormValue(state.getBoost(), numTerms);
    }

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics termStats) {
        long df = termStats.docFreq();
        long max2 = collectionStats.maxDoc();
        float idf = this.idf(df, max2);
        return Explanation.match(idf, "idf(docFreq=" + df + ", maxDocs=" + max2 + ")", new Explanation[0]);
    }

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics[] termStats) {
        long max2 = collectionStats.maxDoc();
        float idf = 0.0f;
        ArrayList<Explanation> details = new ArrayList<Explanation>();
        for (TermStatistics stat : termStats) {
            long df = stat.docFreq();
            float termIdf = this.idf(df, max2);
            details.add(Explanation.match(termIdf, "idf(docFreq=" + df + ", maxDocs=" + max2 + ")", new Explanation[0]));
            idf += termIdf;
        }
        return Explanation.match(idf, "idf(), sum of:", details);
    }

    @Override
    public final Similarity.SimWeight computeWeight(float queryBoost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Explanation idf = termStats.length == 1 ? this.idfExplain(collectionStats, termStats[0]) : this.idfExplain(collectionStats, termStats);
        float avgdl = this.avgFieldLength(collectionStats);
        float[] cache = new float[256];
        for (int i = 0; i < cache.length; ++i) {
            cache[i] = this.k1 * (1.0f - this.b + this.b * this.decodeNormValue((byte)i) / avgdl);
        }
        return new BM25Stats(collectionStats.field(), idf, queryBoost, avgdl, cache);
    }

    @Override
    public final Similarity.SimScorer simScorer(Similarity.SimWeight stats, LeafReaderContext context) throws IOException {
        BM25Stats bm25stats = (BM25Stats)stats;
        return new BM25DocScorer(bm25stats, context.reader().getNormValues(bm25stats.field));
    }

    private Explanation explainTFNorm(int doc2, Explanation freq, BM25Stats stats, NumericDocValues norms) {
        ArrayList<Explanation> subs2 = new ArrayList<Explanation>();
        subs2.add(freq);
        subs2.add(Explanation.match(this.k1, "parameter k1", new Explanation[0]));
        if (norms == null) {
            subs2.add(Explanation.match(0.0f, "parameter b (norms omitted for field)", new Explanation[0]));
            return Explanation.match(freq.getValue() * (this.k1 + 1.0f) / (freq.getValue() + this.k1), "tfNorm, computed from:", subs2);
        }
        float doclen = this.decodeNormValue((byte)norms.get(doc2));
        subs2.add(Explanation.match(this.b, "parameter b", new Explanation[0]));
        subs2.add(Explanation.match(stats.avgdl, "avgFieldLength", new Explanation[0]));
        subs2.add(Explanation.match(doclen, "fieldLength", new Explanation[0]));
        return Explanation.match(freq.getValue() * (this.k1 + 1.0f) / (freq.getValue() + this.k1 * (1.0f - this.b + this.b * doclen / stats.avgdl)), "tfNorm, computed from:", subs2);
    }

    private Explanation explainScore(int doc2, Explanation freq, BM25Stats stats, NumericDocValues norms) {
        Explanation boostExpl = Explanation.match(stats.queryBoost * stats.topLevelBoost, "boost", new Explanation[0]);
        ArrayList<Explanation> subs2 = new ArrayList<Explanation>();
        if (boostExpl.getValue() != 1.0f) {
            subs2.add(boostExpl);
        }
        subs2.add(stats.idf);
        Explanation tfNormExpl = this.explainTFNorm(doc2, freq, stats, norms);
        subs2.add(tfNormExpl);
        return Explanation.match(boostExpl.getValue() * stats.idf.getValue() * tfNormExpl.getValue(), "score(doc=" + doc2 + ",freq=" + freq + "), product of:", subs2);
    }

    public String toString() {
        return "BM25(k1=" + this.k1 + ",b=" + this.b + ")";
    }

    public float getK1() {
        return this.k1;
    }

    public float getB() {
        return this.b;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            float f = SmallFloat.byte315ToFloat((byte)i);
            BM25Similarity.NORM_TABLE[i] = 1.0f / (f * f);
        }
    }

    private static class BM25Stats
    extends Similarity.SimWeight {
        private final Explanation idf;
        private final float avgdl;
        private final float queryBoost;
        private float topLevelBoost;
        private float weight;
        private final String field;
        private final float[] cache;

        BM25Stats(String field, Explanation idf, float queryBoost, float avgdl, float[] cache) {
            this.field = field;
            this.idf = idf;
            this.queryBoost = queryBoost;
            this.avgdl = avgdl;
            this.cache = cache;
        }

        @Override
        public float getValueForNormalization() {
            float queryWeight = this.idf.getValue() * this.queryBoost;
            return queryWeight * queryWeight;
        }

        @Override
        public void normalize(float queryNorm, float topLevelBoost) {
            this.topLevelBoost = topLevelBoost;
            this.weight = this.idf.getValue() * this.queryBoost * topLevelBoost;
        }
    }

    private class BM25DocScorer
    extends Similarity.SimScorer {
        private final BM25Stats stats;
        private final float weightValue;
        private final NumericDocValues norms;
        private final float[] cache;

        BM25DocScorer(BM25Stats stats, NumericDocValues norms) throws IOException {
            this.stats = stats;
            this.weightValue = stats.weight * (BM25Similarity.this.k1 + 1.0f);
            this.cache = stats.cache;
            this.norms = norms;
        }

        @Override
        public float score(int doc2, float freq) {
            float norm = this.norms == null ? BM25Similarity.this.k1 : this.cache[(byte)this.norms.get(doc2) & 0xFF];
            return this.weightValue * freq / (freq + norm);
        }

        @Override
        public Explanation explain(int doc2, Explanation freq) {
            return BM25Similarity.this.explainScore(doc2, freq, this.stats, this.norms);
        }

        @Override
        public float computeSlopFactor(int distance) {
            return BM25Similarity.this.sloppyFreq(distance);
        }

        @Override
        public float computePayloadFactor(int doc2, int start, int end, BytesRef payload) {
            return BM25Similarity.this.scorePayload(doc2, start, end, payload);
        }
    }
}

