/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BaseGlobalOrdinalScorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.LongValues;

final class GlobalOrdinalsQuery
extends Query {
    private final LongBitSet foundOrds;
    private final String joinField;
    private final MultiDocValues.OrdinalMap globalOrds;
    private final Query toQuery;
    private final Query fromQuery;
    private final IndexReader indexReader;

    GlobalOrdinalsQuery(LongBitSet foundOrds, String joinField, MultiDocValues.OrdinalMap globalOrds, Query toQuery, Query fromQuery, IndexReader indexReader) {
        this.foundOrds = foundOrds;
        this.joinField = joinField;
        this.globalOrds = globalOrds;
        this.toQuery = toQuery;
        this.fromQuery = fromQuery;
        this.indexReader = indexReader;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new W(this, this.toQuery.createWeight(searcher, false));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GlobalOrdinalsQuery that = (GlobalOrdinalsQuery)o;
        if (!this.fromQuery.equals(that.fromQuery)) {
            return false;
        }
        if (!this.joinField.equals(that.joinField)) {
            return false;
        }
        if (!this.toQuery.equals(that.toQuery)) {
            return false;
        }
        return this.indexReader.equals(that.indexReader);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.joinField.hashCode();
        result = 31 * result + this.toQuery.hashCode();
        result = 31 * result + this.fromQuery.hashCode();
        result = 31 * result + this.indexReader.hashCode();
        return result;
    }

    @Override
    public String toString(String field) {
        return "GlobalOrdinalsQuery{joinField=" + this.joinField + '}';
    }

    static final class SegmentOrdinalScorer
    extends BaseGlobalOrdinalScorer {
        final LongBitSet foundOrds;

        public SegmentOrdinalScorer(Weight weight, float score, LongBitSet foundOrds, SortedDocValues values, Scorer approximationScorer) {
            super(weight, values, approximationScorer);
            this.score = score;
            this.foundOrds = foundOrds;
        }

        @Override
        public int advance(int target) throws IOException {
            int docID = this.approximationScorer.advance(target);
            while (docID < Integer.MAX_VALUE) {
                long segmentOrd = this.values.getOrd(docID);
                if (segmentOrd != -1L && this.foundOrds.get(segmentOrd)) {
                    return docID;
                }
                docID = this.approximationScorer.nextDoc();
            }
            return Integer.MAX_VALUE;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                @Override
                public boolean matches() throws IOException {
                    long segmentOrd = SegmentOrdinalScorer.this.values.getOrd(SegmentOrdinalScorer.this.approximationScorer.docID());
                    return segmentOrd != -1L && SegmentOrdinalScorer.this.foundOrds.get(segmentOrd);
                }
            };
        }
    }

    static final class OrdinalMapScorer
    extends BaseGlobalOrdinalScorer {
        final LongBitSet foundOrds;
        final LongValues segmentOrdToGlobalOrdLookup;

        public OrdinalMapScorer(Weight weight, float score, LongBitSet foundOrds, SortedDocValues values, Scorer approximationScorer, LongValues segmentOrdToGlobalOrdLookup) {
            super(weight, values, approximationScorer);
            this.score = score;
            this.foundOrds = foundOrds;
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
        }

        @Override
        public int advance(int target) throws IOException {
            int docID = this.approximationScorer.advance(target);
            while (docID < Integer.MAX_VALUE) {
                long globalOrd;
                long segmentOrd = this.values.getOrd(docID);
                if (segmentOrd != -1L && this.foundOrds.get(globalOrd = this.segmentOrdToGlobalOrdLookup.get(segmentOrd))) {
                    return docID;
                }
                docID = this.approximationScorer.nextDoc();
            }
            return Integer.MAX_VALUE;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                @Override
                public boolean matches() throws IOException {
                    long globalOrd;
                    long segmentOrd = OrdinalMapScorer.this.values.getOrd(OrdinalMapScorer.this.approximationScorer.docID());
                    return segmentOrd != -1L && OrdinalMapScorer.this.foundOrds.get(globalOrd = OrdinalMapScorer.this.segmentOrdToGlobalOrdLookup.get(segmentOrd));
                }
            };
        }
    }

    final class W
    extends Weight {
        private final Weight approximationWeight;
        private float queryNorm;
        private float queryWeight;

        W(Query query, Weight approximationWeight) {
            super(query);
            this.approximationWeight = approximationWeight;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc2) throws IOException {
            int segmentOrd;
            SortedDocValues values = DocValues.getSorted(context.reader(), GlobalOrdinalsQuery.this.joinField);
            if (values != null && (segmentOrd = values.getOrd(doc2)) != -1) {
                BytesRef joinValue = values.lookupOrd(segmentOrd);
                return Explanation.match(this.queryNorm, "Score based on join value " + joinValue.utf8ToString(), new Explanation[0]);
            }
            return Explanation.noMatch("Not a match", new Explanation[0]);
        }

        @Override
        public float getValueForNormalization() throws IOException {
            this.queryWeight = GlobalOrdinalsQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
            SortedDocValues values = DocValues.getSorted(context.reader(), GlobalOrdinalsQuery.this.joinField);
            if (values == null) {
                return null;
            }
            Scorer approximationScorer = this.approximationWeight.scorer(context, acceptDocs);
            if (approximationScorer == null) {
                return null;
            }
            if (GlobalOrdinalsQuery.this.globalOrds != null) {
                return new OrdinalMapScorer(this, this.queryNorm, GlobalOrdinalsQuery.this.foundOrds, values, approximationScorer, GlobalOrdinalsQuery.this.globalOrds.getGlobalOrds(context.ord));
            }
            return new SegmentOrdinalScorer(this, this.queryNorm, GlobalOrdinalsQuery.this.foundOrds, values, approximationScorer);
        }
    }
}

