/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenOffsetFilter;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.highlight.TokenStreamFromTermVector;

public class TokenSources {
    private TokenSources() {
    }

    public static TokenStream getTokenStream(String field, Fields tvFields, String text, Analyzer analyzer, int maxStartOffset) throws IOException {
        TokenStream tokenStream = TokenSources.getTermVectorTokenStreamOrNull(field, tvFields, maxStartOffset);
        if (tokenStream != null) {
            return tokenStream;
        }
        tokenStream = analyzer.tokenStream(field, text);
        if (maxStartOffset >= 0 && maxStartOffset < text.length() - 1) {
            tokenStream = new LimitTokenOffsetFilter(tokenStream, maxStartOffset);
        }
        return tokenStream;
    }

    public static TokenStream getTermVectorTokenStreamOrNull(String field, Fields tvFields, int maxStartOffset) throws IOException {
        if (tvFields == null) {
            return null;
        }
        Terms tvTerms = tvFields.terms(field);
        if (tvTerms == null || !tvTerms.hasOffsets()) {
            return null;
        }
        return new TokenStreamFromTermVector(tvTerms, maxStartOffset);
    }

    @Deprecated
    public static TokenStream getAnyTokenStream(IndexReader reader2, int docId, String field, Document document, Analyzer analyzer) throws IOException {
        Terms vector2;
        TokenStream ts = null;
        Fields vectors = reader2.getTermVectors(docId);
        if (vectors != null && (vector2 = vectors.terms(field)) != null) {
            ts = TokenSources.getTokenStream(vector2);
        }
        if (ts == null) {
            ts = TokenSources.getTokenStream(document, field, analyzer);
        }
        return ts;
    }

    @Deprecated
    public static TokenStream getAnyTokenStream(IndexReader reader2, int docId, String field, Analyzer analyzer) throws IOException {
        Terms vector2;
        TokenStream ts = null;
        Fields vectors = reader2.getTermVectors(docId);
        if (vectors != null && (vector2 = vectors.terms(field)) != null) {
            ts = TokenSources.getTokenStream(vector2);
        }
        if (ts == null) {
            ts = TokenSources.getTokenStream(reader2, docId, field, analyzer);
        }
        return ts;
    }

    @Deprecated
    public static TokenStream getTokenStream(Terms vector2, boolean tokenPositionsGuaranteedContiguous) throws IOException {
        return TokenSources.getTokenStream(vector2);
    }

    @Deprecated
    public static TokenStream getTokenStream(Terms tpv) throws IOException {
        if (!tpv.hasOffsets()) {
            throw new IllegalArgumentException("Highlighting requires offsets from the TokenStream.");
        }
        return new TokenStreamFromTermVector(tpv, -1);
    }

    @Deprecated
    public static TokenStream getTokenStreamWithOffsets(IndexReader reader2, int docId, String field) throws IOException {
        Fields vectors = reader2.getTermVectors(docId);
        if (vectors == null) {
            return null;
        }
        Terms vector2 = vectors.terms(field);
        if (vector2 == null) {
            return null;
        }
        if (!vector2.hasOffsets()) {
            return null;
        }
        return TokenSources.getTokenStream(vector2);
    }

    @Deprecated
    public static TokenStream getTokenStream(IndexReader reader2, int docId, String field, Analyzer analyzer) throws IOException {
        Document doc2 = reader2.document(docId);
        return TokenSources.getTokenStream(doc2, field, analyzer);
    }

    @Deprecated
    public static TokenStream getTokenStream(Document doc2, String field, Analyzer analyzer) {
        String contents = doc2.get(field);
        if (contents == null) {
            throw new IllegalArgumentException("Field " + field + " in document is not stored and cannot be analyzed");
        }
        return TokenSources.getTokenStream(field, contents, analyzer);
    }

    @Deprecated
    public static TokenStream getTokenStream(String field, String contents, Analyzer analyzer) {
        try {
            return analyzer.tokenStream(field, contents);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

