/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;

public abstract class Weight {
    protected final Query parentQuery;

    protected Weight(Query query) {
        this.parentQuery = query;
    }

    public abstract void extractTerms(Set<Term> var1);

    public abstract Explanation explain(LeafReaderContext var1, int var2) throws IOException;

    public final Query getQuery() {
        return this.parentQuery;
    }

    public abstract float getValueForNormalization() throws IOException;

    public abstract void normalize(float var1, float var2);

    public abstract Scorer scorer(LeafReaderContext var1, Bits var2) throws IOException;

    public BulkScorer bulkScorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
        Scorer scorer = this.scorer(context, acceptDocs);
        if (scorer == null) {
            return null;
        }
        return new DefaultBulkScorer(scorer);
    }

    protected static class DefaultBulkScorer
    extends BulkScorer {
        private final Scorer scorer;

        public DefaultBulkScorer(Scorer scorer) {
            if (scorer == null) {
                throw new NullPointerException();
            }
            this.scorer = scorer;
        }

        @Override
        public long cost() {
            return this.scorer.cost();
        }

        @Override
        public int score(LeafCollector collector, int min2, int max2) throws IOException {
            collector.setScorer(this.scorer);
            if (this.scorer.docID() == -1 && min2 == 0 && max2 == Integer.MAX_VALUE) {
                DefaultBulkScorer.scoreAll(collector, this.scorer);
                return Integer.MAX_VALUE;
            }
            int doc2 = this.scorer.docID();
            if (doc2 < min2) {
                doc2 = this.scorer.advance(min2);
            }
            return DefaultBulkScorer.scoreRange(collector, this.scorer, doc2, max2);
        }

        static int scoreRange(LeafCollector collector, Scorer scorer, int currentDoc, int end) throws IOException {
            while (currentDoc < end) {
                collector.collect(currentDoc);
                currentDoc = scorer.nextDoc();
            }
            return currentDoc;
        }

        static void scoreAll(LeafCollector collector, Scorer scorer) throws IOException {
            int doc2 = scorer.nextDoc();
            while (doc2 != Integer.MAX_VALUE) {
                collector.collect(doc2);
                doc2 = scorer.nextDoc();
            }
        }
    }
}

