/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public abstract class RandomAccessWeight
extends ConstantScoreWeight {
    protected RandomAccessWeight(Query query) {
        super(query);
    }

    protected abstract Bits getMatchingDocs(LeafReaderContext var1) throws IOException;

    @Override
    public final Scorer scorer(LeafReaderContext context, final Bits acceptDocs) throws IOException {
        final Bits matchingDocs = this.getMatchingDocs(context);
        if (matchingDocs == null || matchingDocs instanceof Bits.MatchNoBits) {
            return null;
        }
        DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
        TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                int doc2 = this.approximation.docID();
                if (acceptDocs != null && !acceptDocs.get(doc2)) {
                    return false;
                }
                return matchingDocs.get(doc2);
            }
        };
        return new ConstantScoreScorer((Weight)this, this.score(), twoPhase);
    }
}

