/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

final class MultiTermQueryConstantScoreWrapper<Q extends MultiTermQuery>
extends Query {
    private static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
    protected final Q query;

    protected MultiTermQueryConstantScoreWrapper(Q query) {
        this.query = query;
    }

    @Override
    public String toString(String field) {
        return ((Query)this.query).toString(field);
    }

    @Override
    public final boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        MultiTermQueryConstantScoreWrapper that = (MultiTermQueryConstantScoreWrapper)o;
        return ((MultiTermQuery)this.query).equals(that.query) && this.getBoost() == that.getBoost();
    }

    @Override
    public final int hashCode() {
        return 31 * super.hashCode() + ((MultiTermQuery)this.query).hashCode();
    }

    public final String getField() {
        return ((MultiTermQuery)this.query).getField();
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            private boolean collectTerms(LeafReaderContext context, TermsEnum termsEnum, List<TermAndState> terms) throws IOException {
                int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
                for (int i = 0; i < threshold; ++i) {
                    BytesRef term = termsEnum.next();
                    if (term == null) {
                        return true;
                    }
                    TermState state = termsEnum.termState();
                    if (!state.isRealTerm()) {
                        return false;
                    }
                    terms.add(new TermAndState(BytesRef.deepCopyOf(term), state, termsEnum.docFreq(), termsEnum.totalTermFreq()));
                }
                return termsEnum.next() == null;
            }

            private WeightOrBitSet rewrite(LeafReaderContext context, Bits acceptDocs) throws IOException {
                Terms terms = context.reader().terms(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field);
                if (terms == null) {
                    return new WeightOrBitSet((BitDocIdSet)null);
                }
                TermsEnum termsEnum = ((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).getTermsEnum(terms);
                assert (termsEnum != null);
                PostingsEnum docs = null;
                ArrayList<TermAndState> collectedTerms = new ArrayList<TermAndState>();
                if (this.collectTerms(context, termsEnum, collectedTerms)) {
                    BooleanQuery bq = new BooleanQuery();
                    for (TermAndState t : collectedTerms) {
                        TermContext termContext = new TermContext(searcher.getTopReaderContext());
                        termContext.register(t.state, context.ord, t.docFreq, t.totalTermFreq);
                        bq.add(new TermQuery(new Term(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field, t.term), termContext), BooleanClause.Occur.SHOULD);
                    }
                    ConstantScoreQuery q = new ConstantScoreQuery(bq);
                    q.setBoost(this.score());
                    return new WeightOrBitSet(searcher.rewrite(q).createWeight(searcher, needsScores));
                }
                BitDocIdSet.Builder builder = new BitDocIdSet.Builder(context.reader().maxDoc());
                if (!collectedTerms.isEmpty()) {
                    TermsEnum termsEnum2 = terms.iterator();
                    for (TermAndState t : collectedTerms) {
                        termsEnum2.seekExact(t.term, t.state);
                        docs = termsEnum2.postings(acceptDocs, docs, 0);
                        builder.or(docs);
                    }
                }
                do {
                    docs = termsEnum.postings(acceptDocs, docs, 0);
                    builder.or(docs);
                } while (termsEnum.next() != null);
                return new WeightOrBitSet(builder.build());
            }

            private Scorer scorer(BitDocIdSet set2) {
                if (set2 == null) {
                    return null;
                }
                DocIdSetIterator disi = set2.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                WeightOrBitSet weightOrBitSet = this.rewrite(context, acceptDocs);
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.bulkScorer(context, acceptDocs);
                }
                Scorer scorer = this.scorer(weightOrBitSet.bitset);
                if (scorer == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer(scorer);
            }

            @Override
            public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                WeightOrBitSet weightOrBitSet = this.rewrite(context, acceptDocs);
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.scorer(context, acceptDocs);
                }
                return this.scorer(weightOrBitSet.bitset);
            }
        };
    }

    private static class WeightOrBitSet {
        final Weight weight;
        final BitDocIdSet bitset;

        WeightOrBitSet(Weight weight) {
            this.weight = Objects.requireNonNull(weight);
            this.bitset = null;
        }

        WeightOrBitSet(BitDocIdSet bitset) {
            this.bitset = bitset;
            this.weight = null;
        }
    }

    private static class TermAndState {
        final BytesRef term;
        final TermState state;
        final int docFreq;
        final long totalTermFreq;

        TermAndState(BytesRef term, TermState state, int docFreq, long totalTermFreq) {
            this.term = term;
            this.state = state;
            this.docFreq = docFreq;
            this.totalTermFreq = totalTermFreq;
        }
    }
}

