/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.RoaringDocIdSet;

public class LRUQueryCache
implements QueryCache,
Accountable {
    static final long QUERY_DEFAULT_RAM_BYTES_USED = 192L;
    static final long HASHTABLE_RAM_BYTES_PER_ENTRY = 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2;
    static final long LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY = HASHTABLE_RAM_BYTES_PER_ENTRY + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    private final int maxSize;
    private final long maxRamBytesUsed;
    private final Map<Query, Query> uniqueQueries;
    private final Set<Query> mostRecentlyUsedQueries;
    private final Map<Object, LeafCache> cache;
    private volatile long ramBytesUsed;
    private volatile long hitCount;
    private volatile long missCount;
    private volatile long cacheCount;
    private volatile long cacheSize;

    private static Query cacheKey(Query query) {
        if (query.getBoost() == 1.0f) {
            return query;
        }
        Query key2 = query.clone();
        key2.setBoost(1.0f);
        assert (key2 == LRUQueryCache.cacheKey(key2));
        return key2;
    }

    public LRUQueryCache(int maxSize, long maxRamBytesUsed) {
        this.maxSize = maxSize;
        this.maxRamBytesUsed = maxRamBytesUsed;
        this.uniqueQueries = new LinkedHashMap<Query, Query>(16, 0.75f, true);
        this.mostRecentlyUsedQueries = this.uniqueQueries.keySet();
        this.cache = new IdentityHashMap<Object, LeafCache>();
        this.ramBytesUsed = 0L;
    }

    protected void onHit(Object readerCoreKey, Query query) {
        ++this.hitCount;
    }

    protected void onMiss(Object readerCoreKey, Query query) {
        assert (query != null);
        ++this.missCount;
    }

    protected void onQueryCache(Query query, long ramBytesUsed) {
        this.ramBytesUsed += ramBytesUsed;
    }

    protected void onQueryEviction(Query query, long ramBytesUsed) {
        this.ramBytesUsed -= ramBytesUsed;
    }

    protected void onDocIdSetCache(Object readerCoreKey, long ramBytesUsed) {
        ++this.cacheSize;
        ++this.cacheCount;
        this.ramBytesUsed += ramBytesUsed;
    }

    protected void onDocIdSetEviction(Object readerCoreKey, int numEntries, long sumRamBytesUsed) {
        this.ramBytesUsed -= sumRamBytesUsed;
        this.cacheSize -= (long)numEntries;
    }

    protected void onClear() {
        this.ramBytesUsed = 0L;
        this.cacheSize = 0L;
    }

    boolean requiresEviction() {
        int size = this.mostRecentlyUsedQueries.size();
        if (size == 0) {
            return false;
        }
        return size > this.maxSize || this.ramBytesUsed() > this.maxRamBytesUsed;
    }

    synchronized DocIdSet get(Query key2, LeafReaderContext context) {
        key2 = LRUQueryCache.cacheKey(key2);
        Object readerKey = context.reader().getCoreCacheKey();
        LeafCache leafCache = this.cache.get(readerKey);
        if (leafCache == null) {
            this.onMiss(readerKey, key2);
            return null;
        }
        Query singleton = this.uniqueQueries.get(key2);
        if (singleton == null) {
            this.onMiss(readerKey, key2);
            return null;
        }
        DocIdSet cached = leafCache.get(singleton);
        if (cached == null) {
            this.onMiss(readerKey, singleton);
        } else {
            this.onHit(readerKey, singleton);
        }
        return cached;
    }

    synchronized void putIfAbsent(Query query, LeafReaderContext context, DocIdSet set2) {
        query = query.clone();
        query.setBoost(1.0f);
        assert (query == LRUQueryCache.cacheKey(query));
        Query singleton = this.uniqueQueries.get(query);
        if (singleton == null) {
            this.uniqueQueries.put(query, query);
            this.onQueryCache(singleton, LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY + this.ramBytesUsed(query));
        } else {
            query = singleton;
        }
        Object key2 = context.reader().getCoreCacheKey();
        LeafCache leafCache = this.cache.get(key2);
        if (leafCache == null) {
            leafCache = new LeafCache(key2);
            LeafCache previous = this.cache.put(context.reader().getCoreCacheKey(), leafCache);
            this.ramBytesUsed += HASHTABLE_RAM_BYTES_PER_ENTRY;
            assert (previous == null);
            context.reader().addCoreClosedListener(new LeafReader.CoreClosedListener(){

                @Override
                public void onClose(Object ownerCoreCacheKey) {
                    LRUQueryCache.this.clearCoreCacheKey(ownerCoreCacheKey);
                }
            });
        }
        leafCache.putIfAbsent(query, set2);
        this.evictIfNecessary();
    }

    synchronized void evictIfNecessary() {
        if (this.requiresEviction()) {
            Iterator<Query> iterator = this.mostRecentlyUsedQueries.iterator();
            do {
                Query query = iterator.next();
                int size = this.mostRecentlyUsedQueries.size();
                iterator.remove();
                if (size == this.mostRecentlyUsedQueries.size()) {
                    throw new ConcurrentModificationException("Removal from the cache failed! This is probably due to a query which has been modified after having been put into  the cache or a badly implemented clone(). Query class: [" + query.getClass() + "], query: [" + query + "]");
                }
                this.onEviction(query);
            } while (iterator.hasNext() && this.requiresEviction());
        }
    }

    public synchronized void clearCoreCacheKey(Object coreKey) {
        LeafCache leafCache = this.cache.remove(coreKey);
        if (leafCache != null) {
            this.ramBytesUsed -= HASHTABLE_RAM_BYTES_PER_ENTRY;
            this.onDocIdSetEviction(coreKey, leafCache.cache.size(), leafCache.ramBytesUsed);
        }
    }

    public synchronized void clearQuery(Query query) {
        Query singleton = this.uniqueQueries.remove(LRUQueryCache.cacheKey(query));
        if (singleton != null) {
            this.onEviction(singleton);
        }
    }

    private void onEviction(Query singleton) {
        this.onQueryEviction(singleton, LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY + this.ramBytesUsed(singleton));
        for (LeafCache leafCache : this.cache.values()) {
            leafCache.remove(singleton);
        }
    }

    public synchronized void clear() {
        this.cache.clear();
        this.mostRecentlyUsedQueries.clear();
        this.onClear();
    }

    synchronized void assertConsistent() {
        if (this.requiresEviction()) {
            throw new AssertionError((Object)("requires evictions: size=" + this.mostRecentlyUsedQueries.size() + ", maxSize=" + this.maxSize + ", ramBytesUsed=" + this.ramBytesUsed() + ", maxRamBytesUsed=" + this.maxRamBytesUsed));
        }
        for (LeafCache leafCache : this.cache.values()) {
            Set keys2 = Collections.newSetFromMap(new IdentityHashMap());
            keys2.addAll(leafCache.cache.keySet());
            keys2.removeAll(this.mostRecentlyUsedQueries);
            if (!keys2.isEmpty()) {
                throw new AssertionError((Object)("One leaf cache contains more keys than the top-level cache: " + keys2));
            }
        }
        long recomputedRamBytesUsed = HASHTABLE_RAM_BYTES_PER_ENTRY * (long)this.cache.size() + LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY * (long)this.uniqueQueries.size();
        for (Query query : this.mostRecentlyUsedQueries) {
            recomputedRamBytesUsed += this.ramBytesUsed(query);
        }
        for (LeafCache leafCache : this.cache.values()) {
            recomputedRamBytesUsed += HASHTABLE_RAM_BYTES_PER_ENTRY * (long)leafCache.cache.size();
            for (DocIdSet set2 : leafCache.cache.values()) {
                recomputedRamBytesUsed += set2.ramBytesUsed();
            }
        }
        if (recomputedRamBytesUsed != this.ramBytesUsed) {
            throw new AssertionError((Object)("ramBytesUsed mismatch : " + this.ramBytesUsed + " != " + recomputedRamBytesUsed));
        }
        long recomputedCacheSize = 0L;
        for (LeafCache leafCache : this.cache.values()) {
            recomputedCacheSize += (long)leafCache.cache.size();
        }
        if (recomputedCacheSize != this.getCacheSize()) {
            throw new AssertionError((Object)("cacheSize mismatch : " + this.getCacheSize() + " != " + recomputedCacheSize));
        }
    }

    synchronized List<Query> cachedQueries() {
        return new ArrayList<Query>(this.mostRecentlyUsedQueries);
    }

    @Override
    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
        while (weight instanceof CachingWrapperWeight) {
            weight = ((CachingWrapperWeight)weight).in;
        }
        return new CachingWrapperWeight(weight, policy);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Accountable> getChildResources() {
        LRUQueryCache lRUQueryCache = this;
        synchronized (lRUQueryCache) {
            return Accountables.namedAccountables("segment", this.cache);
        }
    }

    protected long ramBytesUsed(Query query) {
        if (query instanceof Accountable) {
            return ((Accountable)((Object)query)).ramBytesUsed();
        }
        return 192L;
    }

    protected DocIdSet cacheImpl(DocIdSetIterator iterator, LeafReader reader2) throws IOException {
        return new RoaringDocIdSet.Builder(reader2.maxDoc()).add(iterator).build();
    }

    public final long getTotalCount() {
        return this.getHitCount() + this.getMissCount();
    }

    public final long getHitCount() {
        return this.hitCount;
    }

    public final long getMissCount() {
        return this.missCount;
    }

    public final long getCacheSize() {
        return this.cacheSize;
    }

    public final long getCacheCount() {
        return this.cacheCount;
    }

    public final long getEvictionCount() {
        return this.getCacheCount() - this.getCacheSize();
    }

    private class CachingWrapperWeight
    extends ConstantScoreWeight {
        private final Weight in;
        private final QueryCachingPolicy policy;

        CachingWrapperWeight(Weight in, QueryCachingPolicy policy) {
            super(in.getQuery());
            this.in = in;
            this.policy = policy;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.in.extractTerms(terms);
        }

        private boolean cacheEntryHasReasonableWorstCaseSize(int maxDoc) {
            long worstCaseRamUsage = maxDoc / 8;
            long totalRamAvailable = LRUQueryCache.this.maxRamBytesUsed;
            return worstCaseRamUsage * 5L < totalRamAvailable;
        }

        @Override
        public Scorer scorer(LeafReaderContext context, final Bits acceptDocs) throws IOException {
            DocIdSet docIdSet;
            if (context.ord == 0) {
                this.policy.onUse(this.getQuery());
            }
            if ((docIdSet = LRUQueryCache.this.get(this.in.getQuery(), context)) == null) {
                if (this.cacheEntryHasReasonableWorstCaseSize(ReaderUtil.getTopLevelContext(context).reader().maxDoc()) && this.policy.shouldCache(this.in.getQuery(), context)) {
                    Scorer scorer = this.in.scorer(context, null);
                    docIdSet = scorer == null ? DocIdSet.EMPTY : LRUQueryCache.this.cacheImpl(scorer, context.reader());
                    LRUQueryCache.this.putIfAbsent(this.in.getQuery(), context, docIdSet);
                } else {
                    return this.in.scorer(context, acceptDocs);
                }
            }
            assert (docIdSet != null);
            if (docIdSet == DocIdSet.EMPTY) {
                return null;
            }
            DocIdSetIterator disi = docIdSet.iterator();
            if (disi == null) {
                return null;
            }
            if (acceptDocs == null) {
                return new ConstantScoreScorer((Weight)this, 0.0f, disi);
            }
            TwoPhaseIterator twoPhaseView = new TwoPhaseIterator(disi){

                @Override
                public boolean matches() throws IOException {
                    int doc2 = this.approximation.docID();
                    return acceptDocs.get(doc2);
                }
            };
            return new ConstantScoreScorer((Weight)this, 0.0f, twoPhaseView);
        }
    }

    private class LeafCache
    implements Accountable {
        private final Object key;
        private final Map<Query, DocIdSet> cache;
        private volatile long ramBytesUsed;

        LeafCache(Object key2) {
            this.key = key2;
            this.cache = new IdentityHashMap<Query, DocIdSet>();
            this.ramBytesUsed = 0L;
        }

        private void onDocIdSetCache(long ramBytesUsed) {
            this.ramBytesUsed += ramBytesUsed;
            LRUQueryCache.this.onDocIdSetCache(this.key, ramBytesUsed);
        }

        private void onDocIdSetEviction(long ramBytesUsed) {
            this.ramBytesUsed -= ramBytesUsed;
            LRUQueryCache.this.onDocIdSetEviction(this.key, 1, ramBytesUsed);
        }

        DocIdSet get(Query query) {
            assert (query == LRUQueryCache.cacheKey(query));
            return this.cache.get(query);
        }

        void putIfAbsent(Query query, DocIdSet set2) {
            assert (query == LRUQueryCache.cacheKey(query));
            if (!this.cache.containsKey(query)) {
                this.cache.put(query, set2);
                this.onDocIdSetCache(HASHTABLE_RAM_BYTES_PER_ENTRY + set2.ramBytesUsed());
            }
        }

        void remove(Query query) {
            assert (query == LRUQueryCache.cacheKey(query));
            DocIdSet removed = this.cache.remove(query);
            if (removed != null) {
                this.onDocIdSetEviction(HASHTABLE_RAM_BYTES_PER_ENTRY + removed.ramBytesUsed());
            }
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }
}

