/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public abstract class Filter
extends Query {
    public abstract DocIdSet getDocIdSet(LeafReaderContext var1, Bits var2) throws IOException;

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
            }

            @Override
            public float getValueForNormalization() throws IOException {
                return 0.0f;
            }

            @Override
            public void normalize(float norm, float topLevelBoost) {
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc2) throws IOException {
                boolean match;
                Scorer scorer = this.scorer(context, context.reader().getLiveDocs());
                boolean bl = match = scorer != null && scorer.advance(doc2) == doc2;
                if (match) {
                    assert (scorer.score() == 0.0f);
                    return Explanation.match(0.0f, "Match on id " + doc2, new Explanation[0]);
                }
                return Explanation.match(0.0f, "No match on id " + doc2, new Explanation[0]);
            }

            @Override
            public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                DocIdSet set2 = Filter.this.getDocIdSet(context, acceptDocs);
                if (set2 == null) {
                    return null;
                }
                DocIdSetIterator iterator = set2.iterator();
                if (iterator == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, 0.0f, iterator);
            }
        };
    }
}

