/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class DisjunctionMaxQuery
extends Query
implements Iterable<Query> {
    private ArrayList<Query> disjuncts = new ArrayList();
    private float tieBreakerMultiplier = 0.0f;

    public DisjunctionMaxQuery(float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    public DisjunctionMaxQuery(Collection<Query> disjuncts, float tieBreakerMultiplier) {
        Objects.requireNonNull(disjuncts, "Collection of Querys must not be null");
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.add(disjuncts);
    }

    public void add(Query query) {
        this.disjuncts.add(Objects.requireNonNull(query, "Query must not be null"));
    }

    public void add(Collection<Query> disjuncts) {
        this.disjuncts.addAll(Objects.requireNonNull(disjuncts, "Query connection must not be null"));
    }

    @Override
    public Iterator<Query> iterator() {
        return this.disjuncts.iterator();
    }

    public ArrayList<Query> getDisjuncts() {
        return this.disjuncts;
    }

    public float getTieBreakerMultiplier() {
        return this.tieBreakerMultiplier;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new DisjunctionMaxWeight(searcher, needsScores);
    }

    @Override
    public Query rewrite(IndexReader reader2) throws IOException {
        int numDisjunctions = this.disjuncts.size();
        if (numDisjunctions == 1) {
            Query singleton = this.disjuncts.get(0);
            Query result = singleton.rewrite(reader2);
            if (this.getBoost() != 1.0f) {
                if (result == singleton) {
                    result = result.clone();
                }
                result.setBoost(this.getBoost() * result.getBoost());
            }
            return result;
        }
        DisjunctionMaxQuery clone = null;
        for (int i = 0; i < numDisjunctions; ++i) {
            Query clause = this.disjuncts.get(i);
            Query rewrite = clause.rewrite(reader2);
            if (rewrite == clause) continue;
            if (clone == null) {
                clone = this.clone();
            }
            clone.disjuncts.set(i, rewrite);
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public DisjunctionMaxQuery clone() {
        DisjunctionMaxQuery clone = (DisjunctionMaxQuery)super.clone();
        clone.disjuncts = (ArrayList)this.disjuncts.clone();
        return clone;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        int numDisjunctions = this.disjuncts.size();
        for (int i = 0; i < numDisjunctions; ++i) {
            Query subquery = this.disjuncts.get(i);
            if (subquery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subquery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subquery.toString(field));
            }
            if (i == numDisjunctions - 1) continue;
            buffer.append(" | ");
        }
        buffer.append(")");
        if (this.tieBreakerMultiplier != 0.0f) {
            buffer.append("~");
            buffer.append(this.tieBreakerMultiplier);
        }
        if ((double)this.getBoost() != 1.0) {
            buffer.append("^");
            buffer.append(this.getBoost());
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DisjunctionMaxQuery)) {
            return false;
        }
        DisjunctionMaxQuery other = (DisjunctionMaxQuery)o;
        return super.equals(o) && this.tieBreakerMultiplier == other.tieBreakerMultiplier && this.disjuncts.equals(other.disjuncts);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) + Float.floatToIntBits(this.tieBreakerMultiplier) + this.disjuncts.hashCode();
    }

    protected class DisjunctionMaxWeight
    extends Weight {
        protected final ArrayList<Weight> weights;
        private final boolean needsScores;

        public DisjunctionMaxWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            super(DisjunctionMaxQuery.this);
            this.weights = new ArrayList();
            for (Query disjunctQuery : DisjunctionMaxQuery.this.disjuncts) {
                this.weights.add(disjunctQuery.createWeight(searcher, needsScores));
            }
            this.needsScores = needsScores;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            for (Weight weight : this.weights) {
                weight.extractTerms(terms);
            }
        }

        @Override
        public float getValueForNormalization() throws IOException {
            float max2 = 0.0f;
            float sum = 0.0f;
            for (Weight currentWeight : this.weights) {
                float sub = currentWeight.getValueForNormalization();
                sum += sub;
                max2 = Math.max(max2, sub);
            }
            float boost = DisjunctionMaxQuery.this.getBoost();
            return ((sum - max2) * DisjunctionMaxQuery.this.tieBreakerMultiplier * DisjunctionMaxQuery.this.tieBreakerMultiplier + max2) * boost * boost;
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            topLevelBoost *= DisjunctionMaxQuery.this.getBoost();
            for (Weight wt : this.weights) {
                wt.normalize(norm, topLevelBoost);
            }
        }

        @Override
        public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
            ArrayList<Scorer> scorers = new ArrayList<Scorer>();
            for (Weight w : this.weights) {
                Scorer subScorer = w.scorer(context, acceptDocs);
                if (subScorer == null) continue;
                scorers.add(subScorer);
            }
            if (scorers.isEmpty()) {
                return null;
            }
            if (scorers.size() == 1) {
                return (Scorer)scorers.get(0);
            }
            return new DisjunctionMaxScorer(this, DisjunctionMaxQuery.this.tieBreakerMultiplier, scorers, this.needsScores);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc2) throws IOException {
            boolean match = false;
            float max2 = 0.0f;
            float sum = 0.0f;
            ArrayList<Explanation> subs2 = new ArrayList<Explanation>();
            for (Weight wt : this.weights) {
                Explanation e2 = wt.explain(context, doc2);
                if (!e2.isMatch()) continue;
                match = true;
                subs2.add(e2);
                sum += e2.getValue();
                max2 = Math.max(max2, e2.getValue());
            }
            if (match) {
                float score = max2 + (sum - max2) * DisjunctionMaxQuery.this.tieBreakerMultiplier;
                String desc = DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.tieBreakerMultiplier + " times others of:";
                return Explanation.match(score, desc, subs2);
            }
            return Explanation.noMatch("No matching clause", new Explanation[0]);
        }
    }
}

