/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public abstract class ConstantScoreWeight
extends Weight {
    private float queryNorm = 1.0f;
    private float queryWeight = this.getQuery().getBoost();

    protected ConstantScoreWeight(Query query) {
        super(query);
    }

    @Override
    public void extractTerms(Set<Term> terms) {
    }

    @Override
    public final float getValueForNormalization() throws IOException {
        return this.queryWeight * this.queryWeight;
    }

    @Override
    public final void normalize(float norm, float topLevelBoost) {
        this.queryNorm = norm * topLevelBoost;
        this.queryWeight *= this.queryNorm;
    }

    protected final float score() {
        return this.queryWeight;
    }

    @Override
    public final Explanation explain(LeafReaderContext context, int doc2) throws IOException {
        boolean exists;
        Scorer s = this.scorer(context, context.reader().getLiveDocs());
        if (s == null) {
            exists = false;
        } else {
            TwoPhaseIterator twoPhase = s.asTwoPhaseIterator();
            if (twoPhase == null) {
                exists = s.advance(doc2) == doc2;
            } else {
                boolean bl = exists = twoPhase.approximation().advance(doc2) == doc2 && twoPhase.matches();
            }
        }
        if (exists) {
            return Explanation.match(this.queryWeight, this.getQuery().toString() + ", product of:", Explanation.match(this.getQuery().getBoost(), "boost", new Explanation[0]), Explanation.match(this.queryNorm, "queryNorm", new Explanation[0]));
        }
        return Explanation.noMatch(this.getQuery().toString() + " doesn't match id " + doc2, new Explanation[0]);
    }
}

