/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.builders.SpanBuilderBase;
import org.apache.lucene.queryparser.xml.builders.SpanQueryBuilder;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.w3c.dom.Element;

public class SpanNotBuilder
extends SpanBuilderBase {
    private final SpanQueryBuilder factory;

    public SpanNotBuilder(SpanQueryBuilder factory) {
        this.factory = factory;
    }

    @Override
    public SpanQuery getSpanQuery(Element e2) throws ParserException {
        Element includeElem = DOMUtils.getChildByTagOrFail(e2, "Include");
        includeElem = DOMUtils.getFirstChildOrFail(includeElem);
        Element excludeElem = DOMUtils.getChildByTagOrFail(e2, "Exclude");
        excludeElem = DOMUtils.getFirstChildOrFail(excludeElem);
        SpanQuery include = this.factory.getSpanQuery(includeElem);
        SpanQuery exclude = this.factory.getSpanQuery(excludeElem);
        SpanNotQuery snq = new SpanNotQuery(include, exclude);
        snq.setBoost(DOMUtils.getAttribute(e2, "boost", 1.0f));
        return snq;
    }
}

