/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DisjunctionMaxQueryBuilder
implements QueryBuilder {
    private final QueryBuilder factory;

    public DisjunctionMaxQueryBuilder(QueryBuilder factory) {
        this.factory = factory;
    }

    @Override
    public Query getQuery(Element e2) throws ParserException {
        float tieBreaker = DOMUtils.getAttribute(e2, "tieBreaker", 0.0f);
        DisjunctionMaxQuery dq = new DisjunctionMaxQuery(tieBreaker);
        dq.setBoost(DOMUtils.getAttribute(e2, "boost", 1.0f));
        NodeList nl2 = e2.getChildNodes();
        for (int i = 0; i < nl2.getLength(); ++i) {
            Node node2 = nl2.item(i);
            if (!(node2 instanceof Element)) continue;
            Element queryElem = (Element)node2;
            Query q = this.factory.getQuery(queryElem);
            dq.add(q);
        }
        return dq;
    }
}

