/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import org.apache.lucene.queries.BooleanFilter;
import org.apache.lucene.queries.FilterClause;
import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.FilterBuilder;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.builders.BooleanQueryBuilder;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BooleanFilterBuilder
implements FilterBuilder {
    private final FilterBuilder factory;

    public BooleanFilterBuilder(FilterBuilder factory) {
        this.factory = factory;
    }

    @Override
    public Filter getFilter(Element e2) throws ParserException {
        BooleanFilter bf = new BooleanFilter();
        NodeList nl2 = e2.getChildNodes();
        for (int i = 0; i < nl2.getLength(); ++i) {
            Node node2 = nl2.item(i);
            if (!node2.getNodeName().equals("Clause")) continue;
            Element clauseElem = (Element)node2;
            BooleanClause.Occur occurs = BooleanQueryBuilder.getOccursValue(clauseElem);
            Element clauseFilter = DOMUtils.getFirstChildOrFail(clauseElem);
            Filter f = this.factory.getFilter(clauseFilter);
            bf.add(new FilterClause(f, occurs));
        }
        return bf;
    }
}

