/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.precedence.processors;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.nodes.AndQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.BooleanQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.ModifierQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.OrQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;

public class BooleanModifiersQueryNodeProcessor
extends QueryNodeProcessorImpl {
    private ArrayList<QueryNode> childrenBuffer = new ArrayList();
    private Boolean usingAnd = false;

    @Override
    public QueryNode process(QueryNode queryTree) throws QueryNodeException {
        StandardQueryConfigHandler.Operator op = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.DEFAULT_OPERATOR);
        if (op == null) {
            throw new IllegalArgumentException("StandardQueryConfigHandler.ConfigurationKeys.DEFAULT_OPERATOR should be set on the QueryConfigHandler");
        }
        this.usingAnd = StandardQueryConfigHandler.Operator.AND == op;
        return super.process(queryTree);
    }

    @Override
    protected QueryNode postProcessNode(QueryNode node2) throws QueryNodeException {
        if (node2 instanceof AndQueryNode) {
            this.childrenBuffer.clear();
            List<QueryNode> children2 = node2.getChildren();
            for (QueryNode child : children2) {
                this.childrenBuffer.add(this.applyModifier(child, ModifierQueryNode.Modifier.MOD_REQ));
            }
            node2.set(this.childrenBuffer);
        } else if (this.usingAnd.booleanValue() && node2 instanceof BooleanQueryNode && !(node2 instanceof OrQueryNode)) {
            this.childrenBuffer.clear();
            List<QueryNode> children3 = node2.getChildren();
            for (QueryNode child : children3) {
                this.childrenBuffer.add(this.applyModifier(child, ModifierQueryNode.Modifier.MOD_REQ));
            }
            node2.set(this.childrenBuffer);
        }
        return node2;
    }

    private QueryNode applyModifier(QueryNode node2, ModifierQueryNode.Modifier mod2) {
        if (!(node2 instanceof ModifierQueryNode)) {
            return new ModifierQueryNode(node2, mod2);
        }
        ModifierQueryNode modNode = (ModifierQueryNode)node2;
        if (modNode.getModifier() == ModifierQueryNode.Modifier.MOD_NONE) {
            return new ModifierQueryNode(modNode.getChild(), mod2);
        }
        return node2;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node2) throws QueryNodeException {
        return node2;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children2) throws QueryNodeException {
        return children2;
    }
}

