/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.core.builders;

import java.util.HashMap;
import java.util.List;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.builders.QueryBuilder;
import org.apache.lucene.queryparser.flexible.core.messages.QueryParserMessages;
import org.apache.lucene.queryparser.flexible.core.nodes.FieldableNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.messages.MessageImpl;
import org.apache.lucene.queryparser.flexible.standard.parser.EscapeQuerySyntaxImpl;

public class QueryTreeBuilder
implements QueryBuilder {
    public static final String QUERY_TREE_BUILDER_TAGID = QueryTreeBuilder.class.getName();
    private HashMap<Class<? extends QueryNode>, QueryBuilder> queryNodeBuilders;
    private HashMap<String, QueryBuilder> fieldNameBuilders;

    public void setBuilder(CharSequence fieldName, QueryBuilder builder) {
        if (this.fieldNameBuilders == null) {
            this.fieldNameBuilders = new HashMap();
        }
        this.fieldNameBuilders.put(fieldName.toString(), builder);
    }

    public void setBuilder(Class<? extends QueryNode> queryNodeClass, QueryBuilder builder) {
        if (this.queryNodeBuilders == null) {
            this.queryNodeBuilders = new HashMap();
        }
        this.queryNodeBuilders.put(queryNodeClass, builder);
    }

    private void process(QueryNode node2) throws QueryNodeException {
        if (node2 != null) {
            List<QueryNode> children2;
            QueryBuilder builder = this.getBuilder(node2);
            if (!(builder instanceof QueryTreeBuilder) && (children2 = node2.getChildren()) != null) {
                for (QueryNode child : children2) {
                    this.process(child);
                }
            }
            this.processNode(node2, builder);
        }
    }

    private QueryBuilder getBuilder(QueryNode node2) {
        QueryBuilder builder = null;
        if (this.fieldNameBuilders != null && node2 instanceof FieldableNode) {
            CharSequence field = ((FieldableNode)node2).getField();
            if (field != null) {
                field = field.toString();
            }
            builder = this.fieldNameBuilders.get(field);
        }
        if (builder == null && this.queryNodeBuilders != null) {
            Class<?> clazz = node2.getClass();
            do {
                Class<?> actualClass;
                Class<?>[] classes;
                if ((builder = this.getQueryBuilder(clazz)) != null) continue;
                Class<?>[] arr$ = classes = clazz.getInterfaces();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (builder = this.getQueryBuilder(actualClass = arr$[i$])) == null; ++i$) {
                }
            } while (builder == null && (clazz = clazz.getSuperclass()) != null);
        }
        return builder;
    }

    private void processNode(QueryNode node2, QueryBuilder builder) throws QueryNodeException {
        if (builder == null) {
            throw new QueryNodeException(new MessageImpl(QueryParserMessages.LUCENE_QUERY_CONVERSION_ERROR, node2.toQueryString(new EscapeQuerySyntaxImpl()), node2.getClass().getName()));
        }
        Object obj = builder.build(node2);
        if (obj != null) {
            node2.setTag(QUERY_TREE_BUILDER_TAGID, obj);
        }
    }

    private QueryBuilder getQueryBuilder(Class<?> clazz) {
        if (QueryNode.class.isAssignableFrom(clazz)) {
            return this.queryNodeBuilders.get(clazz);
        }
        return null;
    }

    @Override
    public Object build(QueryNode queryNode) throws QueryNodeException {
        this.process(queryNode);
        return queryNode.getTag(QUERY_TREE_BUILDER_TAGID);
    }
}

