/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.valuesource.DocFreqValueSource;
import org.apache.lucene.util.BytesRef;

public class TermFreqValueSource
extends DocFreqValueSource {
    public TermFreqValueSource(String field, String val2, String indexedField, BytesRef indexedBytes) {
        super(field, val2, indexedField, indexedBytes);
    }

    @Override
    public String name() {
        return "termfreq";
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        Fields fields = readerContext.reader().fields();
        final Terms terms = fields.terms(this.indexedField);
        return new IntDocValues(this){
            PostingsEnum docs;
            int atDoc;
            int lastDocRequested;
            {
                super(x0);
                this.lastDocRequested = -1;
                this.reset();
            }

            public void reset() throws IOException {
                TermsEnum termsEnum;
                this.docs = terms != null ? ((termsEnum = terms.iterator()).seekExact(TermFreqValueSource.this.indexedBytes) ? termsEnum.postings(null, null) : null) : null;
                if (this.docs == null) {
                    this.docs = new PostingsEnum(){

                        @Override
                        public int freq() {
                            return 0;
                        }

                        @Override
                        public int nextPosition() throws IOException {
                            return -1;
                        }

                        @Override
                        public int startOffset() throws IOException {
                            return -1;
                        }

                        @Override
                        public int endOffset() throws IOException {
                            return -1;
                        }

                        @Override
                        public BytesRef getPayload() throws IOException {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public int docID() {
                            return Integer.MAX_VALUE;
                        }

                        @Override
                        public int nextDoc() {
                            return Integer.MAX_VALUE;
                        }

                        @Override
                        public int advance(int target) {
                            return Integer.MAX_VALUE;
                        }

                        @Override
                        public long cost() {
                            return 0L;
                        }
                    };
                }
                this.atDoc = -1;
            }

            @Override
            public int intVal(int doc2) {
                try {
                    if (doc2 < this.lastDocRequested) {
                        this.reset();
                    }
                    this.lastDocRequested = doc2;
                    if (this.atDoc < doc2) {
                        this.atDoc = this.docs.advance(doc2);
                    }
                    if (this.atDoc > doc2) {
                        return 0;
                    }
                    return this.docs.freq();
                }
                catch (IOException e2) {
                    throw new RuntimeException("caught exception in function " + TermFreqValueSource.this.description() + " : doc=" + doc2, e2);
                }
            }
        };
    }
}

