/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.BoolDocValues;
import org.apache.lucene.queries.function.valuesource.BoolFunction;
import org.apache.lucene.search.IndexSearcher;

public abstract class SimpleBoolFunction
extends BoolFunction {
    protected final ValueSource source;

    public SimpleBoolFunction(ValueSource source2) {
        this.source = source2;
    }

    protected abstract String name();

    protected abstract boolean func(int var1, FunctionValues var2);

    @Override
    public BoolDocValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues vals2 = this.source.getValues(context, readerContext);
        return new BoolDocValues(this){

            @Override
            public boolean boolVal(int doc2) {
                return SimpleBoolFunction.this.func(doc2, vals2);
            }

            @Override
            public String toString(int doc2) {
                return SimpleBoolFunction.this.name() + '(' + vals2.toString(doc2) + ')';
            }
        };
    }

    @Override
    public String description() {
        return this.name() + '(' + this.source.description() + ')';
    }

    @Override
    public int hashCode() {
        return this.source.hashCode() + this.name().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SimpleBoolFunction other = (SimpleBoolFunction)o;
        return this.source.equals(other.source);
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.source.createWeight(context, searcher);
    }
}

