/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.MultiFloatFunction;
import org.apache.lucene.queries.function.valuesource.MultiFunction;

public class MaxFloatFunction
extends MultiFloatFunction {
    public MaxFloatFunction(ValueSource[] sources) {
        super(sources);
    }

    @Override
    protected String name() {
        return "max";
    }

    @Override
    protected float func(int doc2, FunctionValues[] valsArr) {
        if (!this.exists(doc2, valsArr)) {
            return 0.0f;
        }
        float val2 = Float.NEGATIVE_INFINITY;
        for (FunctionValues vals2 : valsArr) {
            if (!vals2.exists(doc2)) continue;
            val2 = Math.max(vals2.floatVal(doc2), val2);
        }
        return val2;
    }

    @Override
    protected boolean exists(int doc2, FunctionValues[] valsArr) {
        return MultiFunction.anyExists(doc2, valsArr);
    }
}

