/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueInt;

public class IntFieldSource
extends FieldCacheSource {
    public IntFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "int(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = DocValues.getNumeric(readerContext.reader(), this.field);
        final Bits valid = DocValues.getDocsWithField(readerContext.reader(), this.field);
        return new IntDocValues(this){
            final MutableValueInt val;
            {
                super(x0);
                this.val = new MutableValueInt();
            }

            @Override
            public int intVal(int doc2) {
                return (int)arr.get(doc2);
            }

            @Override
            public String strVal(int doc2) {
                return Integer.toString(this.intVal(doc2));
            }

            @Override
            public boolean exists(int doc2) {
                return arr.get(doc2) != 0L || valid.get(doc2);
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueInt mval = new MutableValueInt();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc2) {
                        this.mval.value = this.intVal(doc2);
                        this.mval.exists = this.mval.value != 0 || valid.get(doc2);
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != IntFieldSource.class) {
            return false;
        }
        IntFieldSource other = (IntFieldSource)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int h = Integer.class.hashCode();
        return h += super.hashCode();
    }
}

