/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueStr;

public class BytesRefFieldSource
extends FieldCacheSource {
    public BytesRefFieldSource(String field) {
        super(field);
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        FieldInfo fieldInfo = readerContext.reader().getFieldInfos().fieldInfo(this.field);
        if (fieldInfo != null && fieldInfo.getDocValuesType() == DocValuesType.BINARY) {
            final BinaryDocValues binaryValues = DocValues.getBinary(readerContext.reader(), this.field);
            final Bits docsWithField = DocValues.getDocsWithField(readerContext.reader(), this.field);
            return new FunctionValues(){

                @Override
                public boolean exists(int doc2) {
                    return docsWithField.get(doc2);
                }

                @Override
                public boolean bytesVal(int doc2, BytesRefBuilder target) {
                    target.copyBytes(binaryValues.get(doc2));
                    return target.length() > 0;
                }

                @Override
                public String strVal(int doc2) {
                    BytesRefBuilder bytes2 = new BytesRefBuilder();
                    return this.bytesVal(doc2, bytes2) ? bytes2.get().utf8ToString() : null;
                }

                @Override
                public Object objectVal(int doc2) {
                    return this.strVal(doc2);
                }

                @Override
                public String toString(int doc2) {
                    return BytesRefFieldSource.this.description() + '=' + this.strVal(doc2);
                }

                @Override
                public FunctionValues.ValueFiller getValueFiller() {
                    return new FunctionValues.ValueFiller(){
                        private final MutableValueStr mval = new MutableValueStr();

                        @Override
                        public MutableValue getValue() {
                            return this.mval;
                        }

                        @Override
                        public void fillValue(int doc2) {
                            this.mval.exists = docsWithField.get(doc2);
                            this.mval.value.clear();
                            this.mval.value.copyBytes(binaryValues.get(doc2));
                        }
                    };
                }
            };
        }
        return new DocTermsIndexDocValues(this, readerContext, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public Object objectVal(int doc2) {
                return this.strVal(doc2);
            }

            @Override
            public String toString(int doc2) {
                return BytesRefFieldSource.this.description() + '=' + this.strVal(doc2);
            }
        };
    }
}

