/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.docvalues;

import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueFloat;

public abstract class FloatDocValues
extends FunctionValues {
    protected final ValueSource vs;

    public FloatDocValues(ValueSource vs) {
        this.vs = vs;
    }

    @Override
    public byte byteVal(int doc2) {
        return (byte)this.floatVal(doc2);
    }

    @Override
    public short shortVal(int doc2) {
        return (short)this.floatVal(doc2);
    }

    @Override
    public abstract float floatVal(int var1);

    @Override
    public int intVal(int doc2) {
        return (int)this.floatVal(doc2);
    }

    @Override
    public long longVal(int doc2) {
        return (long)this.floatVal(doc2);
    }

    @Override
    public double doubleVal(int doc2) {
        return this.floatVal(doc2);
    }

    @Override
    public String strVal(int doc2) {
        return Float.toString(this.floatVal(doc2));
    }

    @Override
    public Object objectVal(int doc2) {
        return this.exists(doc2) ? Float.valueOf(this.floatVal(doc2)) : null;
    }

    @Override
    public String toString(int doc2) {
        return this.vs.description() + '=' + this.strVal(doc2);
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueFloat mval = new MutableValueFloat();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc2) {
                this.mval.value = FloatDocValues.this.floatVal(doc2);
                this.mval.exists = FloatDocValues.this.exists(doc2);
            }
        };
    }
}

