/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.docvalues;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueDouble;

public abstract class DoubleDocValues
extends FunctionValues {
    protected final ValueSource vs;

    public DoubleDocValues(ValueSource vs) {
        this.vs = vs;
    }

    @Override
    public byte byteVal(int doc2) {
        return (byte)this.doubleVal(doc2);
    }

    @Override
    public short shortVal(int doc2) {
        return (short)this.doubleVal(doc2);
    }

    @Override
    public float floatVal(int doc2) {
        return (float)this.doubleVal(doc2);
    }

    @Override
    public int intVal(int doc2) {
        return (int)this.doubleVal(doc2);
    }

    @Override
    public long longVal(int doc2) {
        return (long)this.doubleVal(doc2);
    }

    @Override
    public boolean boolVal(int doc2) {
        return this.doubleVal(doc2) != 0.0;
    }

    @Override
    public abstract double doubleVal(int var1);

    @Override
    public String strVal(int doc2) {
        return Double.toString(this.doubleVal(doc2));
    }

    @Override
    public Object objectVal(int doc2) {
        return this.exists(doc2) ? Double.valueOf(this.doubleVal(doc2)) : null;
    }

    @Override
    public String toString(int doc2) {
        return this.vs.description() + '=' + this.strVal(doc2);
    }

    @Override
    public ValueSourceScorer getRangeScorer(IndexReader reader2, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        double lower = lowerVal == null ? Double.NEGATIVE_INFINITY : Double.parseDouble(lowerVal);
        double upper = upperVal == null ? Double.POSITIVE_INFINITY : Double.parseDouble(upperVal);
        final double l = lower;
        final double u = upper;
        if (includeLower && includeUpper) {
            return new ValueSourceScorer(reader2, this){

                @Override
                public boolean matchesValue(int doc2) {
                    double docVal = DoubleDocValues.this.doubleVal(doc2);
                    return docVal >= l && docVal <= u;
                }
            };
        }
        if (includeLower && !includeUpper) {
            return new ValueSourceScorer(reader2, this){

                @Override
                public boolean matchesValue(int doc2) {
                    double docVal = DoubleDocValues.this.doubleVal(doc2);
                    return docVal >= l && docVal < u;
                }
            };
        }
        if (!includeLower && includeUpper) {
            return new ValueSourceScorer(reader2, this){

                @Override
                public boolean matchesValue(int doc2) {
                    double docVal = DoubleDocValues.this.doubleVal(doc2);
                    return docVal > l && docVal <= u;
                }
            };
        }
        return new ValueSourceScorer(reader2, this){

            @Override
            public boolean matchesValue(int doc2) {
                double docVal = DoubleDocValues.this.doubleVal(doc2);
                return docVal > l && docVal < u;
            }
        };
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueDouble mval = new MutableValueDouble();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc2) {
                this.mval.value = DoubleDocValues.this.doubleVal(doc2);
                this.mval.exists = DoubleDocValues.this.exists(doc2);
            }
        };
    }
}

