/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueFloat;

public abstract class FunctionValues {
    public byte byteVal(int doc2) {
        throw new UnsupportedOperationException();
    }

    public short shortVal(int doc2) {
        throw new UnsupportedOperationException();
    }

    public float floatVal(int doc2) {
        throw new UnsupportedOperationException();
    }

    public int intVal(int doc2) {
        throw new UnsupportedOperationException();
    }

    public long longVal(int doc2) {
        throw new UnsupportedOperationException();
    }

    public double doubleVal(int doc2) {
        throw new UnsupportedOperationException();
    }

    public String strVal(int doc2) {
        throw new UnsupportedOperationException();
    }

    public boolean boolVal(int doc2) {
        return this.intVal(doc2) != 0;
    }

    public boolean bytesVal(int doc2, BytesRefBuilder target) {
        String s = this.strVal(doc2);
        if (s == null) {
            target.clear();
            return false;
        }
        target.copyChars(s);
        return true;
    }

    public Object objectVal(int doc2) {
        return Float.valueOf(this.floatVal(doc2));
    }

    public boolean exists(int doc2) {
        return true;
    }

    public int ordVal(int doc2) {
        throw new UnsupportedOperationException();
    }

    public int numOrd() {
        throw new UnsupportedOperationException();
    }

    public abstract String toString(int var1);

    public ValueFiller getValueFiller() {
        return new ValueFiller(){
            private final MutableValueFloat mval = new MutableValueFloat();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc2) {
                this.mval.value = FunctionValues.this.floatVal(doc2);
            }
        };
    }

    public void byteVal(int doc2, byte[] vals2) {
        throw new UnsupportedOperationException();
    }

    public void shortVal(int doc2, short[] vals2) {
        throw new UnsupportedOperationException();
    }

    public void floatVal(int doc2, float[] vals2) {
        throw new UnsupportedOperationException();
    }

    public void intVal(int doc2, int[] vals2) {
        throw new UnsupportedOperationException();
    }

    public void longVal(int doc2, long[] vals2) {
        throw new UnsupportedOperationException();
    }

    public void doubleVal(int doc2, double[] vals2) {
        throw new UnsupportedOperationException();
    }

    public void strVal(int doc2, String[] vals2) {
        throw new UnsupportedOperationException();
    }

    public Explanation explain(int doc2) {
        return Explanation.match(this.floatVal(doc2), this.toString(doc2), new Explanation[0]);
    }

    public ValueSourceScorer getScorer(IndexReader reader2) {
        return new ValueSourceScorer(reader2, this);
    }

    public ValueSourceScorer getRangeScorer(IndexReader reader2, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        float lower = lowerVal == null ? Float.NEGATIVE_INFINITY : Float.parseFloat(lowerVal);
        float upper = upperVal == null ? Float.POSITIVE_INFINITY : Float.parseFloat(upperVal);
        final float l = lower;
        final float u = upper;
        if (includeLower && includeUpper) {
            return new ValueSourceScorer(reader2, this){

                @Override
                public boolean matchesValue(int doc2) {
                    float docVal = FunctionValues.this.floatVal(doc2);
                    return docVal >= l && docVal <= u;
                }
            };
        }
        if (includeLower && !includeUpper) {
            return new ValueSourceScorer(reader2, this){

                @Override
                public boolean matchesValue(int doc2) {
                    float docVal = FunctionValues.this.floatVal(doc2);
                    return docVal >= l && docVal < u;
                }
            };
        }
        if (!includeLower && includeUpper) {
            return new ValueSourceScorer(reader2, this){

                @Override
                public boolean matchesValue(int doc2) {
                    float docVal = FunctionValues.this.floatVal(doc2);
                    return docVal > l && docVal <= u;
                }
            };
        }
        return new ValueSourceScorer(reader2, this){

            @Override
            public boolean matchesValue(int doc2) {
                float docVal = FunctionValues.this.floatVal(doc2);
                return docVal > l && docVal < u;
            }
        };
    }

    public static abstract class ValueFiller {
        public abstract MutableValue getValue();

        public abstract void fillValue(int var1);
    }
}

