/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;

public class CustomScoreProvider {
    protected final LeafReaderContext context;

    public CustomScoreProvider(LeafReaderContext context) {
        this.context = context;
    }

    public float customScore(int doc2, float subQueryScore, float[] valSrcScores) throws IOException {
        if (valSrcScores.length == 1) {
            return this.customScore(doc2, subQueryScore, valSrcScores[0]);
        }
        if (valSrcScores.length == 0) {
            return this.customScore(doc2, subQueryScore, 1.0f);
        }
        float score = subQueryScore;
        for (float valSrcScore : valSrcScores) {
            score *= valSrcScore;
        }
        return score;
    }

    public float customScore(int doc2, float subQueryScore, float valSrcScore) throws IOException {
        return subQueryScore * valSrcScore;
    }

    public Explanation customExplain(int doc2, Explanation subQueryExpl, Explanation[] valSrcExpls) throws IOException {
        if (valSrcExpls.length == 1) {
            return this.customExplain(doc2, subQueryExpl, valSrcExpls[0]);
        }
        if (valSrcExpls.length == 0) {
            return subQueryExpl;
        }
        float valSrcScore = 1.0f;
        for (Explanation valSrcExpl : valSrcExpls) {
            valSrcScore *= valSrcExpl.getValue();
        }
        ArrayList<Explanation> subs2 = new ArrayList<Explanation>();
        subs2.add(subQueryExpl);
        for (Explanation valSrcExpl : valSrcExpls) {
            subs2.add(valSrcExpl);
        }
        return Explanation.match(valSrcScore * subQueryExpl.getValue(), "custom score: product of:", subs2);
    }

    public Explanation customExplain(int doc2, Explanation subQueryExpl, Explanation valSrcExpl) throws IOException {
        float valSrcScore = 1.0f;
        if (valSrcExpl != null) {
            valSrcScore *= valSrcExpl.getValue();
        }
        return Explanation.match(valSrcScore * subQueryExpl.getValue(), "custom score: product of:", subQueryExpl, valSrcExpl);
    }
}

