/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;

public class TieredMergePolicy
extends MergePolicy {
    public static final double DEFAULT_NO_CFS_RATIO = 0.1;
    private int maxMergeAtOnce = 10;
    private long maxMergedSegmentBytes = 0x140000000L;
    private int maxMergeAtOnceExplicit = 30;
    private long floorSegmentBytes = 0x200000L;
    private double segsPerTier = 10.0;
    private double forceMergeDeletesPctAllowed = 10.0;
    private double reclaimDeletesWeight = 2.0;

    public TieredMergePolicy() {
        super(0.1, Long.MAX_VALUE);
    }

    public TieredMergePolicy setMaxMergeAtOnce(int v) {
        if (v < 2) {
            throw new IllegalArgumentException("maxMergeAtOnce must be > 1 (got " + v + ")");
        }
        this.maxMergeAtOnce = v;
        return this;
    }

    public int getMaxMergeAtOnce() {
        return this.maxMergeAtOnce;
    }

    public TieredMergePolicy setMaxMergeAtOnceExplicit(int v) {
        if (v < 2) {
            throw new IllegalArgumentException("maxMergeAtOnceExplicit must be > 1 (got " + v + ")");
        }
        this.maxMergeAtOnceExplicit = v;
        return this;
    }

    public int getMaxMergeAtOnceExplicit() {
        return this.maxMergeAtOnceExplicit;
    }

    public TieredMergePolicy setMaxMergedSegmentMB(double v) {
        if (v < 0.0) {
            throw new IllegalArgumentException("maxMergedSegmentMB must be >=0 (got " + v + ")");
        }
        this.maxMergedSegmentBytes = (v *= 1048576.0) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)v;
        return this;
    }

    public double getMaxMergedSegmentMB() {
        return (double)(this.maxMergedSegmentBytes / 1024L) / 1024.0;
    }

    public TieredMergePolicy setReclaimDeletesWeight(double v) {
        if (v < 0.0) {
            throw new IllegalArgumentException("reclaimDeletesWeight must be >= 0.0 (got " + v + ")");
        }
        this.reclaimDeletesWeight = v;
        return this;
    }

    public double getReclaimDeletesWeight() {
        return this.reclaimDeletesWeight;
    }

    public TieredMergePolicy setFloorSegmentMB(double v) {
        if (v <= 0.0) {
            throw new IllegalArgumentException("floorSegmentMB must be >= 0.0 (got " + v + ")");
        }
        this.floorSegmentBytes = (v *= 1048576.0) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)v;
        return this;
    }

    public double getFloorSegmentMB() {
        return (double)this.floorSegmentBytes / 1048576.0;
    }

    public TieredMergePolicy setForceMergeDeletesPctAllowed(double v) {
        if (v < 0.0 || v > 100.0) {
            throw new IllegalArgumentException("forceMergeDeletesPctAllowed must be between 0.0 and 100.0 inclusive (got " + v + ")");
        }
        this.forceMergeDeletesPctAllowed = v;
        return this;
    }

    public double getForceMergeDeletesPctAllowed() {
        return this.forceMergeDeletesPctAllowed;
    }

    public TieredMergePolicy setSegmentsPerTier(double v) {
        if (v < 2.0) {
            throw new IllegalArgumentException("segmentsPerTier must be >= 2.0 (got " + v + ")");
        }
        this.segsPerTier = v;
        return this;
    }

    public double getSegmentsPerTier() {
        return this.segsPerTier;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos infos, IndexWriter writer2) throws IOException {
        MergePolicy.MergeSpecification spec;
        block21: {
            double segCountLevel;
            long segBytes;
            int tooBigCount;
            if (this.verbose(writer2)) {
                this.message("findMerges: " + infos.size() + " segments", writer2);
            }
            if (infos.size() == 0) {
                return null;
            }
            Collection<SegmentCommitInfo> merging = writer2.getMergingSegments();
            HashSet<SegmentCommitInfo> toBeMerged = new HashSet<SegmentCommitInfo>();
            ArrayList<SegmentCommitInfo> infosSorted = new ArrayList<SegmentCommitInfo>(infos.asList());
            Collections.sort(infosSorted, new SegmentByteSizeDescending(writer2));
            long totIndexBytes = 0L;
            long minSegmentBytes = Long.MAX_VALUE;
            for (SegmentCommitInfo info2 : infosSorted) {
                long segBytes2 = this.size(info2, writer2);
                if (this.verbose(writer2)) {
                    String extra;
                    String string2 = extra = merging.contains(info2) ? " [merging]" : "";
                    if ((double)segBytes2 >= (double)this.maxMergedSegmentBytes / 2.0) {
                        extra = extra + " [skip: too large]";
                    } else if (segBytes2 < this.floorSegmentBytes) {
                        extra = extra + " [floored]";
                    }
                    this.message("  seg=" + writer2.segString(info2) + " size=" + String.format(Locale.ROOT, "%.3f", (double)(segBytes2 / 1024L) / 1024.0) + " MB" + extra, writer2);
                }
                minSegmentBytes = Math.min(segBytes2, minSegmentBytes);
                totIndexBytes += segBytes2;
            }
            for (tooBigCount = 0; tooBigCount < infosSorted.size() && !((double)(segBytes = this.size((SegmentCommitInfo)infosSorted.get(tooBigCount), writer2)) < (double)this.maxMergedSegmentBytes / 2.0); ++tooBigCount) {
                totIndexBytes -= segBytes;
            }
            long levelSize = minSegmentBytes = this.floorSize(minSegmentBytes);
            long bytesLeft = totIndexBytes;
            double allowedSegCount = 0.0;
            while (!((segCountLevel = (double)bytesLeft / (double)levelSize) < this.segsPerTier)) {
                allowedSegCount += this.segsPerTier;
                bytesLeft = (long)((double)bytesLeft - this.segsPerTier * (double)levelSize);
                levelSize *= (long)this.maxMergeAtOnce;
            }
            int allowedSegCountInt = (int)(allowedSegCount += Math.ceil(segCountLevel));
            spec = null;
            while (true) {
                boolean maxMergeIsRunning;
                long mergingBytes = 0L;
                ArrayList<SegmentCommitInfo> eligible = new ArrayList<SegmentCommitInfo>();
                for (int idx = tooBigCount; idx < infosSorted.size(); ++idx) {
                    SegmentCommitInfo info3 = (SegmentCommitInfo)infosSorted.get(idx);
                    if (merging.contains(info3)) {
                        mergingBytes += this.size(info3, writer2);
                        continue;
                    }
                    if (toBeMerged.contains(info3)) continue;
                    eligible.add(info3);
                }
                boolean bl = maxMergeIsRunning = mergingBytes >= this.maxMergedSegmentBytes;
                if (this.verbose(writer2)) {
                    this.message("  allowedSegmentCount=" + allowedSegCountInt + " vs count=" + infosSorted.size() + " (eligible count=" + eligible.size() + ") tooBigCount=" + tooBigCount, writer2);
                }
                if (eligible.size() == 0) {
                    return spec;
                }
                if (eligible.size() <= allowedSegCountInt) break block21;
                MergeScore bestScore = null;
                ArrayList<SegmentCommitInfo> best = null;
                boolean bestTooLarge = false;
                long bestMergeBytes = 0L;
                for (int startIdx = 0; startIdx <= eligible.size() - this.maxMergeAtOnce; ++startIdx) {
                    long totAfterMergeBytes = 0L;
                    ArrayList<SegmentCommitInfo> candidate = new ArrayList<SegmentCommitInfo>();
                    boolean hitTooLarge = false;
                    for (int idx = startIdx; idx < eligible.size() && candidate.size() < this.maxMergeAtOnce; ++idx) {
                        SegmentCommitInfo info4 = (SegmentCommitInfo)eligible.get(idx);
                        long segBytes3 = this.size(info4, writer2);
                        if (totAfterMergeBytes + segBytes3 > this.maxMergedSegmentBytes) {
                            hitTooLarge = true;
                            continue;
                        }
                        candidate.add(info4);
                        totAfterMergeBytes += segBytes3;
                    }
                    assert (candidate.size() > 0);
                    MergeScore score = this.score(candidate, hitTooLarge, mergingBytes, writer2);
                    if (this.verbose(writer2)) {
                        this.message("  maybe=" + writer2.segString(candidate) + " score=" + score.getScore() + " " + score.getExplanation() + " tooLarge=" + hitTooLarge + " size=" + String.format(Locale.ROOT, "%.3f MB", (double)totAfterMergeBytes / 1024.0 / 1024.0), writer2);
                    }
                    if (bestScore != null && !(score.getScore() < bestScore.getScore()) || hitTooLarge && maxMergeIsRunning) continue;
                    best = candidate;
                    bestScore = score;
                    bestTooLarge = hitTooLarge;
                    bestMergeBytes = totAfterMergeBytes;
                }
                if (best == null) break;
                if (spec == null) {
                    spec = new MergePolicy.MergeSpecification();
                }
                MergePolicy.OneMerge merge2 = new MergePolicy.OneMerge(best);
                spec.add(merge2);
                for (SegmentCommitInfo info5 : merge2.segments) {
                    toBeMerged.add(info5);
                }
                if (!this.verbose(writer2)) continue;
                this.message("  add merge=" + writer2.segString(merge2.segments) + " size=" + String.format(Locale.ROOT, "%.3f MB", (double)bestMergeBytes / 1024.0 / 1024.0) + " score=" + String.format(Locale.ROOT, "%.3f", bestScore.getScore()) + " " + bestScore.getExplanation() + (bestTooLarge ? " [max merge]" : ""), writer2);
            }
            return spec;
        }
        return spec;
    }

    protected MergeScore score(List<SegmentCommitInfo> candidate, boolean hitTooLarge, long mergingBytes, IndexWriter writer2) throws IOException {
        long totBeforeMergeBytes = 0L;
        long totAfterMergeBytes = 0L;
        long totAfterMergeBytesFloored = 0L;
        for (SegmentCommitInfo info2 : candidate) {
            long segBytes = this.size(info2, writer2);
            totAfterMergeBytes += segBytes;
            totAfterMergeBytesFloored += this.floorSize(segBytes);
            totBeforeMergeBytes += info2.sizeInBytes();
        }
        final double skew = hitTooLarge ? 1.0 / (double)this.maxMergeAtOnce : (double)this.floorSize(this.size(candidate.get(0), writer2)) / (double)totAfterMergeBytesFloored;
        double mergeScore = skew;
        mergeScore *= Math.pow(totAfterMergeBytes, 0.05);
        final double nonDelRatio = (double)totAfterMergeBytes / (double)totBeforeMergeBytes;
        final double finalMergeScore = mergeScore *= Math.pow(nonDelRatio, this.reclaimDeletesWeight);
        return new MergeScore(){

            @Override
            public double getScore() {
                return finalMergeScore;
            }

            @Override
            public String getExplanation() {
                return "skew=" + String.format(Locale.ROOT, "%.3f", skew) + " nonDelRatio=" + String.format(Locale.ROOT, "%.3f", nonDelRatio);
            }
        };
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos infos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer2) throws IOException {
        int end;
        if (this.verbose(writer2)) {
            this.message("findForcedMerges maxSegmentCount=" + maxSegmentCount + " infos=" + writer2.segString(infos) + " segmentsToMerge=" + segmentsToMerge, writer2);
        }
        ArrayList<SegmentCommitInfo> eligible = new ArrayList<SegmentCommitInfo>();
        boolean forceMergeRunning = false;
        Collection<SegmentCommitInfo> merging = writer2.getMergingSegments();
        boolean segmentIsOriginal = false;
        for (SegmentCommitInfo info2 : infos) {
            Boolean isOriginal = segmentsToMerge.get(info2);
            if (isOriginal == null) continue;
            segmentIsOriginal = isOriginal;
            if (!merging.contains(info2)) {
                eligible.add(info2);
                continue;
            }
            forceMergeRunning = true;
        }
        if (eligible.size() == 0) {
            return null;
        }
        if (maxSegmentCount > 1 && eligible.size() <= maxSegmentCount || maxSegmentCount == 1 && eligible.size() == 1 && (!segmentIsOriginal || this.isMerged(infos, (SegmentCommitInfo)eligible.get(0), writer2))) {
            if (this.verbose(writer2)) {
                this.message("already merged", writer2);
            }
            return null;
        }
        Collections.sort(eligible, new SegmentByteSizeDescending(writer2));
        if (this.verbose(writer2)) {
            this.message("eligible=" + eligible, writer2);
            this.message("forceMergeRunning=" + forceMergeRunning, writer2);
        }
        MergePolicy.MergeSpecification spec = null;
        for (end = eligible.size(); end >= this.maxMergeAtOnceExplicit + maxSegmentCount - 1; end -= this.maxMergeAtOnceExplicit) {
            if (spec == null) {
                spec = new MergePolicy.MergeSpecification();
            }
            MergePolicy.OneMerge merge2 = new MergePolicy.OneMerge(eligible.subList(end - this.maxMergeAtOnceExplicit, end));
            if (this.verbose(writer2)) {
                this.message("add merge=" + writer2.segString(merge2.segments), writer2);
            }
            spec.add(merge2);
        }
        if (spec == null && !forceMergeRunning) {
            int numToMerge = end - maxSegmentCount + 1;
            MergePolicy.OneMerge merge3 = new MergePolicy.OneMerge(eligible.subList(end - numToMerge, end));
            if (this.verbose(writer2)) {
                this.message("add final merge=" + merge3.segString(), writer2);
            }
            spec = new MergePolicy.MergeSpecification();
            spec.add(merge3);
        }
        return spec;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos infos, IndexWriter writer2) throws IOException {
        if (this.verbose(writer2)) {
            this.message("findForcedDeletesMerges infos=" + writer2.segString(infos) + " forceMergeDeletesPctAllowed=" + this.forceMergeDeletesPctAllowed, writer2);
        }
        ArrayList<SegmentCommitInfo> eligible = new ArrayList<SegmentCommitInfo>();
        Collection<SegmentCommitInfo> merging = writer2.getMergingSegments();
        for (SegmentCommitInfo info2 : infos) {
            double pctDeletes = 100.0 * (double)writer2.numDeletedDocs(info2) / (double)info2.info.maxDoc();
            if (!(pctDeletes > this.forceMergeDeletesPctAllowed) || merging.contains(info2)) continue;
            eligible.add(info2);
        }
        if (eligible.size() == 0) {
            return null;
        }
        Collections.sort(eligible, new SegmentByteSizeDescending(writer2));
        if (this.verbose(writer2)) {
            this.message("eligible=" + eligible, writer2);
        }
        int start = 0;
        MergePolicy.MergeSpecification spec = null;
        while (start < eligible.size()) {
            int end = Math.min(start + this.maxMergeAtOnceExplicit, eligible.size());
            if (spec == null) {
                spec = new MergePolicy.MergeSpecification();
            }
            MergePolicy.OneMerge merge2 = new MergePolicy.OneMerge(eligible.subList(start, end));
            if (this.verbose(writer2)) {
                this.message("add merge=" + writer2.segString(merge2.segments), writer2);
            }
            spec.add(merge2);
            start = end;
        }
        return spec;
    }

    private long floorSize(long bytes2) {
        return Math.max(this.floorSegmentBytes, bytes2);
    }

    private boolean verbose(IndexWriter writer2) {
        return writer2 != null && writer2.infoStream.isEnabled("TMP");
    }

    private void message(String message, IndexWriter writer2) {
        writer2.infoStream.message("TMP", message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[" + this.getClass().getSimpleName() + ": ");
        sb.append("maxMergeAtOnce=").append(this.maxMergeAtOnce).append(", ");
        sb.append("maxMergeAtOnceExplicit=").append(this.maxMergeAtOnceExplicit).append(", ");
        sb.append("maxMergedSegmentMB=").append((double)(this.maxMergedSegmentBytes / 1024L) / 1024.0).append(", ");
        sb.append("floorSegmentMB=").append((double)(this.floorSegmentBytes / 1024L) / 1024.0).append(", ");
        sb.append("forceMergeDeletesPctAllowed=").append(this.forceMergeDeletesPctAllowed).append(", ");
        sb.append("segmentsPerTier=").append(this.segsPerTier).append(", ");
        sb.append("maxCFSSegmentSizeMB=").append(this.getMaxCFSSegmentSizeMB()).append(", ");
        sb.append("noCFSRatio=").append(this.noCFSRatio);
        return sb.toString();
    }

    protected static abstract class MergeScore {
        protected MergeScore() {
        }

        abstract double getScore();

        abstract String getExplanation();
    }

    private class SegmentByteSizeDescending
    implements Comparator<SegmentCommitInfo> {
        private final IndexWriter writer;

        SegmentByteSizeDescending(IndexWriter writer2) {
            this.writer = writer2;
        }

        @Override
        public int compare(SegmentCommitInfo o1, SegmentCommitInfo o2) {
            try {
                long sz1 = TieredMergePolicy.this.size(o1, this.writer);
                long sz2 = TieredMergePolicy.this.size(o2, this.writer);
                if (sz1 > sz2) {
                    return -1;
                }
                if (sz2 > sz1) {
                    return 1;
                }
                return o1.info.name.compareTo(o2.info.name);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }
}

