/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.Bits;

public final class SlowCompositeReaderWrapper
extends LeafReader {
    private final CompositeReader in;
    private final Fields fields;
    private final Bits liveDocs;
    private final boolean merging;
    private final Map<String, MultiDocValues.OrdinalMap> cachedOrdMaps = new HashMap<String, MultiDocValues.OrdinalMap>();

    public static LeafReader wrap(IndexReader reader2) throws IOException {
        if (reader2 instanceof CompositeReader) {
            return new SlowCompositeReaderWrapper((CompositeReader)reader2, false);
        }
        assert (reader2 instanceof LeafReader);
        return (LeafReader)reader2;
    }

    SlowCompositeReaderWrapper(CompositeReader reader2, boolean merging) throws IOException {
        this.in = reader2;
        this.fields = MultiFields.getFields(this.in);
        this.liveDocs = MultiFields.getLiveDocs(this.in);
        this.in.registerParentReader(this);
        this.merging = merging;
    }

    public String toString() {
        return "SlowCompositeReaderWrapper(" + this.in + ")";
    }

    @Override
    public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
        SlowCompositeReaderWrapper.addCoreClosedListenerAsReaderClosedListener(this.in, listener);
    }

    @Override
    public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
        SlowCompositeReaderWrapper.removeCoreClosedListenerAsReaderClosedListener(this.in, listener);
    }

    @Override
    public Fields fields() {
        this.ensureOpen();
        return this.fields;
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNumericValues(this.in, field);
    }

    @Override
    public Bits getDocsWithField(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getDocsWithField(this.in, field);
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getBinaryValues(this.in, field);
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getSortedNumericValues(this.in, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        MultiDocValues.OrdinalMap map2 = null;
        Map<String, MultiDocValues.OrdinalMap> map3 = this.cachedOrdMaps;
        synchronized (map3) {
            map2 = this.cachedOrdMaps.get(field);
            if (map2 == null) {
                SortedDocValues dv = MultiDocValues.getSortedValues(this.in, field);
                if (dv instanceof MultiDocValues.MultiSortedDocValues) {
                    map2 = ((MultiDocValues.MultiSortedDocValues)dv).mapping;
                    if (map2.owner == this.getCoreCacheKey() && !this.merging) {
                        this.cachedOrdMaps.put(field, map2);
                    }
                }
                return dv;
            }
        }
        if (this.getFieldInfos().fieldInfo(field).getDocValuesType() != DocValuesType.SORTED) {
            return null;
        }
        int size = this.in.leaves().size();
        SortedDocValues[] values = new SortedDocValues[size];
        int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = this.in.leaves().get(i);
            SortedDocValues v = context.reader().getSortedDocValues(field);
            if (v == null) {
                v = DocValues.emptySorted();
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = this.maxDoc();
        return new MultiDocValues.MultiSortedDocValues(values, starts, map2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        MultiDocValues.OrdinalMap map2 = null;
        Map<String, MultiDocValues.OrdinalMap> map3 = this.cachedOrdMaps;
        synchronized (map3) {
            map2 = this.cachedOrdMaps.get(field);
            if (map2 == null) {
                SortedSetDocValues dv = MultiDocValues.getSortedSetValues(this.in, field);
                if (dv instanceof MultiDocValues.MultiSortedSetDocValues) {
                    map2 = ((MultiDocValues.MultiSortedSetDocValues)dv).mapping;
                    if (map2.owner == this.getCoreCacheKey() && !this.merging) {
                        this.cachedOrdMaps.put(field, map2);
                    }
                }
                return dv;
            }
        }
        if (this.getFieldInfos().fieldInfo(field).getDocValuesType() != DocValuesType.SORTED_SET) {
            return null;
        }
        assert (map2 != null);
        int size = this.in.leaves().size();
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = this.in.leaves().get(i);
            SortedSetDocValues v = context.reader().getSortedSetDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedSet();
            }
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = this.maxDoc();
        return new MultiDocValues.MultiSortedSetDocValues(values, starts, map2);
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNormValues(this.in, field);
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        this.ensureOpen();
        return this.in.getTermVectors(docID);
    }

    @Override
    public int numDocs() {
        return this.in.numDocs();
    }

    @Override
    public int maxDoc() {
        return this.in.maxDoc();
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        this.in.document(docID, visitor);
    }

    @Override
    public Bits getLiveDocs() {
        this.ensureOpen();
        return this.liveDocs;
    }

    @Override
    public FieldInfos getFieldInfos() {
        this.ensureOpen();
        return MultiFields.getMergedFieldInfos(this.in);
    }

    @Override
    public Object getCoreCacheKey() {
        return this.in.getCoreCacheKey();
    }

    @Override
    public Object getCombinedCoreAndDeletesKey() {
        return this.in.getCombinedCoreAndDeletesKey();
    }

    @Override
    protected void doClose() throws IOException {
        this.in.close();
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        for (LeafReaderContext ctx : this.in.leaves()) {
            ctx.reader().checkIntegrity();
        }
    }
}

