/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;

public final class SlowCodecReaderWrapper {
    private SlowCodecReaderWrapper() {
    }

    public static CodecReader wrap(final LeafReader reader2) throws IOException {
        if (reader2 instanceof CodecReader) {
            return (CodecReader)reader2;
        }
        reader2.checkIntegrity();
        return new CodecReader(){

            @Override
            public TermVectorsReader getTermVectorsReader() {
                reader2.ensureOpen();
                return SlowCodecReaderWrapper.readerToTermVectorsReader(reader2);
            }

            @Override
            public StoredFieldsReader getFieldsReader() {
                reader2.ensureOpen();
                return SlowCodecReaderWrapper.readerToStoredFieldsReader(reader2);
            }

            @Override
            public NormsProducer getNormsReader() {
                reader2.ensureOpen();
                return SlowCodecReaderWrapper.readerToNormsProducer(reader2);
            }

            @Override
            public DocValuesProducer getDocValuesReader() {
                reader2.ensureOpen();
                return SlowCodecReaderWrapper.readerToDocValuesProducer(reader2);
            }

            @Override
            public FieldsProducer getPostingsReader() {
                reader2.ensureOpen();
                try {
                    return SlowCodecReaderWrapper.readerToFieldsProducer(reader2);
                }
                catch (IOException bogus) {
                    throw new AssertionError((Object)bogus);
                }
            }

            @Override
            public FieldInfos getFieldInfos() {
                return reader2.getFieldInfos();
            }

            @Override
            public Bits getLiveDocs() {
                return reader2.getLiveDocs();
            }

            @Override
            public int numDocs() {
                return reader2.numDocs();
            }

            @Override
            public int maxDoc() {
                return reader2.maxDoc();
            }

            @Override
            public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
                reader2.addCoreClosedListener(listener);
            }

            @Override
            public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
                reader2.removeCoreClosedListener(listener);
            }
        };
    }

    private static NormsProducer readerToNormsProducer(final LeafReader reader2) {
        return new NormsProducer(){

            @Override
            public NumericDocValues getNorms(FieldInfo field) throws IOException {
                return reader2.getNormValues(field.name);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    private static DocValuesProducer readerToDocValuesProducer(final LeafReader reader2) {
        return new DocValuesProducer(){

            @Override
            public NumericDocValues getNumeric(FieldInfo field) throws IOException {
                return reader2.getNumericDocValues(field.name);
            }

            @Override
            public BinaryDocValues getBinary(FieldInfo field) throws IOException {
                return reader2.getBinaryDocValues(field.name);
            }

            @Override
            public SortedDocValues getSorted(FieldInfo field) throws IOException {
                return reader2.getSortedDocValues(field.name);
            }

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                return reader2.getSortedNumericDocValues(field.name);
            }

            @Override
            public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
                return reader2.getSortedSetDocValues(field.name);
            }

            @Override
            public Bits getDocsWithField(FieldInfo field) throws IOException {
                return reader2.getDocsWithField(field.name);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    private static StoredFieldsReader readerToStoredFieldsReader(final LeafReader reader2) {
        return new StoredFieldsReader(){

            @Override
            public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
                reader2.document(docID, visitor);
            }

            @Override
            public StoredFieldsReader clone() {
                return SlowCodecReaderWrapper.readerToStoredFieldsReader(reader2);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    private static TermVectorsReader readerToTermVectorsReader(final LeafReader reader2) {
        return new TermVectorsReader(){

            @Override
            public Fields get(int docID) throws IOException {
                return reader2.getTermVectors(docID);
            }

            @Override
            public TermVectorsReader clone() {
                return SlowCodecReaderWrapper.readerToTermVectorsReader(reader2);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    private static FieldsProducer readerToFieldsProducer(LeafReader reader2) throws IOException {
        final Fields fields = reader2.fields();
        return new FieldsProducer(){

            @Override
            public Iterator<String> iterator() {
                return fields.iterator();
            }

            @Override
            public Terms terms(String field) throws IOException {
                return fields.terms(field);
            }

            @Override
            public int size() {
                return fields.size();
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }
}

