/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public final class SegmentInfos
implements Cloneable,
Iterable<SegmentCommitInfo> {
    public static final int VERSION_40 = 0;
    public static final int VERSION_46 = 1;
    public static final int VERSION_48 = 2;
    public static final int VERSION_49 = 3;
    public static final int VERSION_50 = 4;
    public static final int VERSION_51 = 5;
    static final int VERSION_CURRENT = 5;
    public int counter;
    public long version;
    private long generation;
    private long lastGeneration;
    public Map<String, String> userData = Collections.emptyMap();
    private List<SegmentCommitInfo> segments = new ArrayList<SegmentCommitInfo>();
    private static PrintStream infoStream = null;
    private byte[] id;
    private static final List<String> unsupportedCodecs = Arrays.asList("Lucene3x");
    boolean pendingCommit;

    public SegmentCommitInfo info(int i) {
        return this.segments.get(i);
    }

    public static long getLastCommitGeneration(String[] files) {
        long max2 = -1L;
        for (String file2 : files) {
            long gen;
            if (!file2.startsWith("segments") || file2.equals("segments.gen") || (gen = SegmentInfos.generationFromSegmentsFileName(file2)) <= max2) continue;
            max2 = gen;
        }
        return max2;
    }

    public static long getLastCommitGeneration(Directory directory) throws IOException {
        return SegmentInfos.getLastCommitGeneration(directory.listAll());
    }

    public static String getLastCommitSegmentsFileName(String[] files) {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(files));
    }

    public static String getLastCommitSegmentsFileName(Directory directory) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(directory));
    }

    public String getSegmentsFileName() {
        return IndexFileNames.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    public static long generationFromSegmentsFileName(String fileName) {
        if (fileName.equals("segments")) {
            return 0L;
        }
        if (fileName.startsWith("segments")) {
            return Long.parseLong(fileName.substring(1 + "segments".length()), 36);
        }
        throw new IllegalArgumentException("fileName \"" + fileName + "\" is not a segments file");
    }

    private long getNextPendingGeneration() {
        if (this.generation == -1L) {
            return 1L;
        }
        return this.generation + 1L;
    }

    public byte[] getId() {
        return this.id == null ? null : (byte[])this.id.clone();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final SegmentInfos readCommit(Directory directory, String segmentFileName) throws IOException {
        long generation = SegmentInfos.generationFromSegmentsFileName(segmentFileName);
        try (ChecksumIndexInput input = directory.openChecksumInput(segmentFileName, IOContext.READ);){
            int magic = input.readInt();
            if (magic != 1071082519) {
                throw new IndexFormatTooOldException(input, magic, 1071082519, 1071082519);
            }
            int format2 = CodecUtil.checkHeaderNoMagic(input, "segments", 0, 5);
            byte[] id = null;
            if (format2 >= 4) {
                id = new byte[16];
                input.readBytes(id, 0, id.length);
                CodecUtil.checkIndexHeaderSuffix(input, Long.toString(generation, 36));
            }
            SegmentInfos infos = new SegmentInfos();
            infos.id = id;
            infos.generation = generation;
            infos.lastGeneration = generation;
            infos.version = input.readLong();
            infos.counter = input.readInt();
            int numSegments = input.readInt();
            if (numSegments < 0) {
                throw new CorruptIndexException("invalid segment count: " + numSegments, input);
            }
            long totalDocs = 0L;
            for (int seg = 0; seg < numSegments; ++seg) {
                byte[] segmentID;
                String segName = input.readString();
                if (format2 >= 4) {
                    byte hasID = input.readByte();
                    if (hasID == 1) {
                        segmentID = new byte[16];
                        input.readBytes(segmentID, 0, segmentID.length);
                    } else {
                        if (hasID != 0) throw new CorruptIndexException("invalid hasID byte, got: " + hasID, input);
                        segmentID = null;
                    }
                } else {
                    segmentID = null;
                }
                Codec codec = SegmentInfos.readCodec(input);
                SegmentInfo info2 = codec.segmentInfoFormat().read(directory, segName, segmentID, IOContext.READ);
                info2.setCodec(codec);
                totalDocs += (long)info2.maxDoc();
                long delGen = input.readLong();
                int delCount = input.readInt();
                if (delCount < 0 || delCount > info2.maxDoc()) {
                    throw new CorruptIndexException("invalid deletion count: " + delCount + " vs maxDoc=" + info2.maxDoc(), input);
                }
                long fieldInfosGen = -1L;
                if (format2 >= 1) {
                    fieldInfosGen = input.readLong();
                }
                long dvGen = -1L;
                dvGen = format2 >= 3 ? input.readLong() : fieldInfosGen;
                SegmentCommitInfo siPerCommit = new SegmentCommitInfo(info2, delCount, delGen, fieldInfosGen, dvGen);
                if (format2 >= 1) {
                    if (format2 < 3) {
                        Map<Long, Set<String>> genUpdatesFiles;
                        int n = input.readInt();
                        if (n == 0) {
                            genUpdatesFiles = Collections.emptyMap();
                        } else {
                            genUpdatesFiles = new HashMap(n);
                            for (int i = 0; i < n; ++i) {
                                genUpdatesFiles.put(input.readLong(), input.readStringSet());
                            }
                        }
                        siPerCommit.setGenUpdatesFiles(genUpdatesFiles);
                    } else {
                        void var26_30;
                        if (format2 >= 5) {
                            siPerCommit.setFieldInfosFiles(input.readSetOfStrings());
                        } else {
                            siPerCommit.setFieldInfosFiles(Collections.unmodifiableSet(input.readStringSet()));
                        }
                        int numDVFields = input.readInt();
                        if (numDVFields == 0) {
                            Map map2 = Collections.emptyMap();
                        } else {
                            HashMap<Integer, Set<String>> map3 = new HashMap<Integer, Set<String>>(numDVFields);
                            for (int i = 0; i < numDVFields; ++i) {
                                if (format2 >= 5) {
                                    map3.put(input.readInt(), input.readSetOfStrings());
                                    continue;
                                }
                                map3.put(input.readInt(), Collections.unmodifiableSet(input.readStringSet()));
                            }
                            Map map4 = Collections.unmodifiableMap(map3);
                        }
                        siPerCommit.setDocValuesUpdatesFiles((Map<Integer, Set<String>>)var26_30);
                    }
                }
                infos.add(siPerCommit);
            }
            infos.userData = format2 >= 5 ? input.readMapOfStrings() : Collections.unmodifiableMap(input.readStringStringMap());
            if (format2 >= 2) {
                CodecUtil.checkFooter(input);
            } else {
                long checksumThen;
                long checksumNow = input.getChecksum();
                if (checksumNow != (checksumThen = input.readLong())) {
                    throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + Long.toHexString(checksumThen) + " actual=" + Long.toHexString(checksumNow), input);
                }
                CodecUtil.checkEOF(input);
            }
            if (totalDocs > (long)IndexWriter.getActualMaxDocs()) {
                throw new CorruptIndexException("Too many documents: an index cannot exceed " + IndexWriter.getActualMaxDocs() + " but readers have total maxDoc=" + totalDocs, input);
            }
            SegmentInfos segmentInfos = infos;
            return segmentInfos;
        }
    }

    private static Codec readCodec(DataInput input) throws IOException {
        String name2 = input.readString();
        try {
            return Codec.forName(name2);
        }
        catch (IllegalArgumentException e2) {
            if (unsupportedCodecs.contains(name2)) {
                IndexFormatTooOldException newExc = new IndexFormatTooOldException(input, "Codec '" + name2 + "' is too old");
                newExc.initCause(e2);
                throw newExc;
            }
            if (name2.startsWith("Lucene")) {
                throw new IllegalArgumentException("Could not load codec '" + name2 + "'.  Did you forget to add lucene-backward-codecs.jar?", e2);
            }
            throw e2;
        }
    }

    public static final SegmentInfos readLatestCommit(Directory directory) throws IOException {
        return (SegmentInfos)new FindSegmentsFile<SegmentInfos>(directory){

            @Override
            protected SegmentInfos doBody(String segmentFileName) throws IOException {
                return SegmentInfos.readCommit(this.directory, segmentFileName);
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Directory directory) throws IOException {
        IndexOutput segnOutput;
        String segmentFileName;
        block11: {
            long nextGeneration = this.getNextPendingGeneration();
            segmentFileName = IndexFileNames.fileNameFromGeneration("pending_segments", "", nextGeneration);
            this.generation = nextGeneration;
            segnOutput = null;
            boolean success = false;
            try {
                segnOutput = directory.createOutput(segmentFileName, IOContext.DEFAULT);
                CodecUtil.writeIndexHeader(segnOutput, "segments", 5, StringHelper.randomId(), Long.toString(nextGeneration, 36));
                segnOutput.writeLong(this.version);
                segnOutput.writeInt(this.counter);
                segnOutput.writeInt(this.size());
                for (SegmentCommitInfo siPerCommit : this) {
                    SegmentInfo si = siPerCommit.info;
                    segnOutput.writeString(si.name);
                    byte[] segmentID = si.getId();
                    if (segmentID == null) {
                        segnOutput.writeByte((byte)0);
                    } else {
                        if (segmentID.length != 16) {
                            throw new IllegalStateException("cannot write segment: invalid id segment=" + si.name + "id=" + StringHelper.idToString(segmentID));
                        }
                        segnOutput.writeByte((byte)1);
                        segnOutput.writeBytes(segmentID, segmentID.length);
                    }
                    segnOutput.writeString(si.getCodec().getName());
                    segnOutput.writeLong(siPerCommit.getDelGen());
                    int delCount = siPerCommit.getDelCount();
                    if (delCount < 0 || delCount > si.maxDoc()) {
                        throw new IllegalStateException("cannot write segment: invalid maxDoc segment=" + si.name + " maxDoc=" + si.maxDoc() + " delCount=" + delCount);
                    }
                    segnOutput.writeInt(delCount);
                    segnOutput.writeLong(siPerCommit.getFieldInfosGen());
                    segnOutput.writeLong(siPerCommit.getDocValuesGen());
                    segnOutput.writeSetOfStrings(siPerCommit.getFieldInfosFiles());
                    Map<Integer, Set<String>> dvUpdatesFiles = siPerCommit.getDocValuesUpdatesFiles();
                    segnOutput.writeInt(dvUpdatesFiles.size());
                    for (Map.Entry<Integer, Set<String>> e2 : dvUpdatesFiles.entrySet()) {
                        segnOutput.writeInt(e2.getKey());
                        segnOutput.writeSetOfStrings(e2.getValue());
                    }
                    assert (si.dir == directory);
                }
                segnOutput.writeMapOfStrings(this.userData);
                CodecUtil.writeFooter(segnOutput);
                segnOutput.close();
                directory.sync(Collections.singleton(segmentFileName));
                success = true;
                if (!success) break block11;
                this.pendingCommit = true;
            }
            catch (Throwable throwable) {
                if (success) {
                    this.pendingCommit = true;
                } else {
                    IOUtils.closeWhileHandlingException(segnOutput);
                    IOUtils.deleteFilesIgnoringExceptions(directory, segmentFileName);
                }
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(segnOutput);
        IOUtils.deleteFilesIgnoringExceptions(directory, segmentFileName);
    }

    public SegmentInfos clone() {
        try {
            SegmentInfos sis = (SegmentInfos)super.clone();
            sis.segments = new ArrayList<SegmentCommitInfo>(this.size());
            for (SegmentCommitInfo info2 : this) {
                assert (info2.info.getCodec() != null);
                sis.add(info2.clone());
            }
            sis.userData = new HashMap<String, String>(this.userData);
            return sis;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException("should not happen", e2);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getLastGeneration() {
        return this.lastGeneration;
    }

    public static void setInfoStream(PrintStream infoStream) {
        SegmentInfos.infoStream = infoStream;
    }

    public static PrintStream getInfoStream() {
        return infoStream;
    }

    private static void message(String message) {
        infoStream.println("SIS [" + Thread.currentThread().getName() + "]: " + message);
    }

    void updateGeneration(SegmentInfos other) {
        this.lastGeneration = other.lastGeneration;
        this.generation = other.generation;
    }

    void setGeneration(long generation) {
        this.generation = generation;
        this.lastGeneration = generation;
    }

    final void rollbackCommit(Directory dir2) {
        if (this.pendingCommit) {
            this.pendingCommit = false;
            String pending = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
            IOUtils.deleteFilesIgnoringExceptions(dir2, pending);
        }
    }

    final void prepareCommit(Directory dir2) throws IOException {
        if (this.pendingCommit) {
            throw new IllegalStateException("prepareCommit was already called");
        }
        this.write(dir2);
    }

    @Deprecated
    public final Collection<String> files(Directory dir2, boolean includeSegmentsFile) throws IOException {
        return this.files(includeSegmentsFile);
    }

    public Collection<String> files(boolean includeSegmentsFile) throws IOException {
        String segmentFileName;
        HashSet<String> files = new HashSet<String>();
        if (includeSegmentsFile && (segmentFileName = this.getSegmentsFileName()) != null) {
            files.add(segmentFileName);
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            SegmentCommitInfo info2 = this.info(i);
            files.addAll(info2.files());
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String finishCommit(Directory dir2) throws IOException {
        String dest;
        if (!this.pendingCommit) {
            throw new IllegalStateException("prepareCommit was not called");
        }
        boolean success = false;
        try {
            String src = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
            dest = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
            dir2.renameFile(src, dest);
            success = true;
        }
        finally {
            if (!success) {
                this.rollbackCommit(dir2);
            }
        }
        this.pendingCommit = false;
        this.lastGeneration = this.generation;
        return dest;
    }

    final void commit(Directory dir2) throws IOException {
        this.prepareCommit(dir2);
        this.finishCommit(dir2);
    }

    @Deprecated
    public String toString(Directory dir2) {
        return this.toString();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getSegmentsFileName()).append(": ");
        int count2 = this.size();
        for (int i = 0; i < count2; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            SegmentCommitInfo info2 = this.info(i);
            buffer.append(info2.toString(0));
        }
        return buffer.toString();
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    void setUserData(Map<String, String> data2) {
        this.userData = data2 == null ? Collections.emptyMap() : data2;
        this.changed();
    }

    void replace(SegmentInfos other) {
        this.rollbackSegmentInfos(other.asList());
        this.lastGeneration = other.lastGeneration;
    }

    public int totalMaxDoc() {
        long count2 = 0L;
        for (SegmentCommitInfo info2 : this) {
            count2 += (long)info2.info.maxDoc();
        }
        assert (count2 <= (long)IndexWriter.getActualMaxDocs());
        return (int)count2;
    }

    public void changed() {
        ++this.version;
    }

    void applyMergeChanges(MergePolicy.OneMerge merge2, boolean dropSegment) {
        HashSet<SegmentCommitInfo> mergedAway = new HashSet<SegmentCommitInfo>(merge2.segments);
        boolean inserted = false;
        int newSegIdx = 0;
        int cnt = this.segments.size();
        for (int segIdx = 0; segIdx < cnt; ++segIdx) {
            assert (segIdx >= newSegIdx);
            SegmentCommitInfo info2 = this.segments.get(segIdx);
            if (mergedAway.contains(info2)) {
                if (inserted || dropSegment) continue;
                this.segments.set(segIdx, merge2.info);
                inserted = true;
                ++newSegIdx;
                continue;
            }
            this.segments.set(newSegIdx, info2);
            ++newSegIdx;
        }
        this.segments.subList(newSegIdx, this.segments.size()).clear();
        if (!inserted && !dropSegment) {
            this.segments.add(0, merge2.info);
        }
    }

    List<SegmentCommitInfo> createBackupSegmentInfos() {
        ArrayList<SegmentCommitInfo> list = new ArrayList<SegmentCommitInfo>(this.size());
        for (SegmentCommitInfo info2 : this) {
            assert (info2.info.getCodec() != null);
            list.add(info2.clone());
        }
        return list;
    }

    void rollbackSegmentInfos(List<SegmentCommitInfo> infos) {
        this.clear();
        this.addAll(infos);
    }

    @Override
    public Iterator<SegmentCommitInfo> iterator() {
        return this.asList().iterator();
    }

    public List<SegmentCommitInfo> asList() {
        return Collections.unmodifiableList(this.segments);
    }

    public int size() {
        return this.segments.size();
    }

    public void add(SegmentCommitInfo si) {
        this.segments.add(si);
    }

    public void addAll(Iterable<SegmentCommitInfo> sis) {
        for (SegmentCommitInfo si : sis) {
            this.add(si);
        }
    }

    public void clear() {
        this.segments.clear();
    }

    public void remove(SegmentCommitInfo si) {
        this.segments.remove(si);
    }

    void remove(int index2) {
        this.segments.remove(index2);
    }

    boolean contains(SegmentCommitInfo si) {
        return this.segments.contains(si);
    }

    int indexOf(SegmentCommitInfo si) {
        return this.segments.indexOf(si);
    }

    public static abstract class FindSegmentsFile<T> {
        final Directory directory;

        public FindSegmentsFile(Directory directory) {
            this.directory = directory;
        }

        public T run() throws IOException {
            return this.run(null);
        }

        public T run(IndexCommit commit) throws IOException {
            if (commit != null) {
                if (this.directory != commit.getDirectory()) {
                    throw new IOException("the specified commit does not match the specified Directory");
                }
                return this.doBody(commit.getSegmentsFileName());
            }
            long lastGen = -1L;
            long gen = -1L;
            IOException exc = null;
            while (true) {
                lastGen = gen;
                Object[] files = this.directory.listAll();
                Object[] files2 = this.directory.listAll();
                Arrays.sort(files);
                Arrays.sort(files2);
                if (!Arrays.equals(files, files2)) continue;
                gen = SegmentInfos.getLastCommitGeneration((String[])files);
                if (infoStream != null) {
                    SegmentInfos.message("directory listing gen=" + gen);
                }
                if (gen == -1L) {
                    throw new IndexNotFoundException("no segments* file found in " + this.directory + ": files: " + Arrays.toString(files));
                }
                if (gen <= lastGen) break;
                String segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen);
                try {
                    T t = this.doBody(segmentFileName);
                    if (infoStream != null) {
                        SegmentInfos.message("success on " + segmentFileName);
                    }
                    return t;
                }
                catch (IOException err) {
                    if (exc == null) {
                        exc = err;
                    }
                    if (infoStream == null) continue;
                    SegmentInfos.message("primary Exception on '" + segmentFileName + "': " + err + "'; will retry: gen = " + gen);
                    continue;
                }
                break;
            }
            throw exc;
        }

        protected abstract T doBody(String var1) throws IOException;
    }
}

