/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;

public class PKIndexSplitter {
    private final Filter docsInFirstIndex;
    private final Directory input;
    private final Directory dir1;
    private final Directory dir2;
    private final IndexWriterConfig config1;
    private final IndexWriterConfig config2;

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Filter docsInFirstIndex) {
        this(input, dir1, dir2, docsInFirstIndex, PKIndexSplitter.newDefaultConfig(), PKIndexSplitter.newDefaultConfig());
    }

    private static IndexWriterConfig newDefaultConfig() {
        return new IndexWriterConfig(null).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
    }

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Filter docsInFirstIndex, IndexWriterConfig config1, IndexWriterConfig config2) {
        this.input = input;
        this.dir1 = dir1;
        this.dir2 = dir2;
        this.docsInFirstIndex = docsInFirstIndex;
        this.config1 = config1;
        this.config2 = config2;
    }

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Term midTerm) {
        this(input, dir1, dir2, new QueryWrapperFilter(new TermRangeQuery(midTerm.field(), null, midTerm.bytes(), true, false)));
    }

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Term midTerm, IndexWriterConfig config1, IndexWriterConfig config2) {
        this(input, dir1, dir2, new QueryWrapperFilter(new TermRangeQuery(midTerm.field(), null, midTerm.bytes(), true, false)), config1, config2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split() throws IOException {
        block5: {
            DirectoryReader reader2;
            block4: {
                boolean success = false;
                reader2 = DirectoryReader.open(this.input);
                try {
                    this.createIndex(this.config1, this.dir1, reader2, this.docsInFirstIndex, false);
                    this.createIndex(this.config2, this.dir2, reader2, this.docsInFirstIndex, true);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(reader2);
                    } else {
                        IOUtils.closeWhileHandlingException(reader2);
                    }
                    throw throwable;
                }
                IOUtils.close(reader2);
                break block5;
            }
            IOUtils.closeWhileHandlingException(reader2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(IndexWriterConfig config, Directory target, DirectoryReader reader2, Filter preserveFilter, boolean negateFilter) throws IOException {
        block6: {
            IndexWriter w;
            block5: {
                boolean success = false;
                w = new IndexWriter(target, config);
                try {
                    List<LeafReaderContext> leaves = reader2.leaves();
                    CodecReader[] subReaders = new CodecReader[leaves.size()];
                    int i = 0;
                    for (LeafReaderContext ctx : leaves) {
                        subReaders[i++] = new DocumentFilteredLeafIndexReader(ctx, preserveFilter, negateFilter);
                    }
                    w.addIndexes(subReaders);
                    success = true;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        w.close();
                    } else {
                        IOUtils.closeWhileHandlingException(w);
                    }
                    throw throwable;
                }
                w.close();
                break block6;
            }
            IOUtils.closeWhileHandlingException(w);
        }
    }

    private static class DocumentFilteredLeafIndexReader
    extends FilterCodecReader {
        final Bits liveDocs;
        final int numDocs;

        public DocumentFilteredLeafIndexReader(LeafReaderContext context, Filter preserveFilter, boolean negateFilter) throws IOException {
            super((CodecReader)context.reader());
            DocIdSetIterator it;
            int maxDoc = this.in.maxDoc();
            FixedBitSet bits = new FixedBitSet(maxDoc);
            DocIdSet docs = preserveFilter.getDocIdSet(context, null);
            if (docs != null && (it = docs.iterator()) != null) {
                bits.or(it);
            }
            if (negateFilter) {
                bits.flip(0, maxDoc);
            }
            if (this.in.hasDeletions()) {
                Bits oldLiveDocs = this.in.getLiveDocs();
                assert (oldLiveDocs != null);
                BitSetIterator it2 = new BitSetIterator(bits, 0L);
                int i = ((DocIdSetIterator)it2).nextDoc();
                while (i < maxDoc) {
                    if (!oldLiveDocs.get(i)) {
                        bits.clear(i);
                    }
                    i = ((DocIdSetIterator)it2).nextDoc();
                }
            }
            this.liveDocs = bits;
            this.numDocs = bits.cardinality();
        }

        @Override
        public int numDocs() {
            return this.numDocs;
        }

        @Override
        public Bits getLiveDocs() {
            return this.liveDocs;
        }
    }
}

