/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.util.Bits;

final class MultiBits
implements Bits {
    private final Bits[] subs;
    private final int[] starts;
    private final boolean defaultValue;

    public MultiBits(Bits[] subs2, int[] starts, boolean defaultValue) {
        assert (starts.length == 1 + subs2.length);
        this.subs = subs2;
        this.starts = starts;
        this.defaultValue = defaultValue;
    }

    private boolean checkLength(int reader2, int doc2) {
        int length = this.starts[1 + reader2] - this.starts[reader2];
        assert (doc2 - this.starts[reader2] < length) : "doc=" + doc2 + " reader=" + reader2 + " starts[reader]=" + this.starts[reader2] + " length=" + length;
        return true;
    }

    @Override
    public boolean get(int doc2) {
        int reader2 = ReaderUtil.subIndex(doc2, this.starts);
        assert (reader2 != -1);
        Bits bits = this.subs[reader2];
        if (bits == null) {
            return this.defaultValue;
        }
        assert (this.checkLength(reader2, doc2));
        return bits.get(doc2 - this.starts[reader2]);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.subs.length + " subs: ");
        for (int i = 0; i < this.subs.length; ++i) {
            if (i != 0) {
                b.append("; ");
            }
            if (this.subs[i] == null) {
                b.append("s=" + this.starts[i] + " l=null");
                continue;
            }
            b.append("s=" + this.starts[i] + " l=" + this.subs[i].length() + " b=" + this.subs[i]);
        }
        b.append(" end=" + this.starts[this.subs.length]);
        return b.toString();
    }

    public SubResult getMatchingSub(ReaderSlice slice) {
        int reader2 = ReaderUtil.subIndex(slice.start, this.starts);
        assert (reader2 != -1);
        assert (reader2 < this.subs.length) : "slice=" + slice + " starts[-1]=" + this.starts[this.starts.length - 1];
        SubResult subResult = new SubResult();
        if (this.starts[reader2] == slice.start && this.starts[1 + reader2] == slice.start + slice.length) {
            subResult.matches = true;
            subResult.result = this.subs[reader2];
        } else {
            subResult.matches = false;
        }
        return subResult;
    }

    @Override
    public int length() {
        return this.starts[this.starts.length - 1];
    }

    public static final class SubResult {
        public boolean matches;
        public Bits result;
    }
}

