/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

class FrozenBufferedUpdates {
    static final int BYTES_PER_DEL_QUERY = RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4 + 24;
    final PrefixCodedTerms terms;
    final Query[] queries;
    final int[] queryLimits;
    final DocValuesUpdate.NumericDocValuesUpdate[] numericDVUpdates;
    final DocValuesUpdate.BinaryDocValuesUpdate[] binaryDVUpdates;
    final int bytesUsed;
    final int numTermDeletes;
    private long gen = -1L;
    final boolean isSegmentPrivate;

    public FrozenBufferedUpdates(BufferedUpdates deletes, boolean isSegmentPrivate) {
        this.isSegmentPrivate = isSegmentPrivate;
        assert (!isSegmentPrivate || deletes.terms.size() == 0) : "segment private package should only have del queries";
        Comparable[] termsArray = deletes.terms.keySet().toArray(new Term[deletes.terms.size()]);
        ArrayUtil.timSort((Comparable[])termsArray);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        for (Comparable term : termsArray) {
            builder.add((Term)term);
        }
        this.terms = builder.finish();
        this.queries = new Query[deletes.queries.size()];
        this.queryLimits = new int[deletes.queries.size()];
        int upto = 0;
        for (Map.Entry<Query, Integer> ent : deletes.queries.entrySet()) {
            this.queries[upto] = ent.getKey();
            this.queryLimits[upto] = ent.getValue();
            ++upto;
        }
        ArrayList<DocValuesUpdate.NumericDocValuesUpdate> allNumericUpdates = new ArrayList<DocValuesUpdate.NumericDocValuesUpdate>();
        int numericUpdatesSize = 0;
        for (LinkedHashMap<Term, DocValuesUpdate.NumericDocValuesUpdate> numericUpdates : deletes.numericUpdates.values()) {
            for (DocValuesUpdate.NumericDocValuesUpdate numericDocValuesUpdate : numericUpdates.values()) {
                allNumericUpdates.add(numericDocValuesUpdate);
                numericUpdatesSize += numericDocValuesUpdate.sizeInBytes();
            }
        }
        this.numericDVUpdates = allNumericUpdates.toArray(new DocValuesUpdate.NumericDocValuesUpdate[allNumericUpdates.size()]);
        ArrayList<DocValuesUpdate.BinaryDocValuesUpdate> allBinaryUpdates = new ArrayList<DocValuesUpdate.BinaryDocValuesUpdate>();
        int binaryUpdatesSize = 0;
        for (LinkedHashMap linkedHashMap : deletes.binaryUpdates.values()) {
            for (DocValuesUpdate.BinaryDocValuesUpdate update3 : linkedHashMap.values()) {
                allBinaryUpdates.add(update3);
                binaryUpdatesSize += update3.sizeInBytes();
            }
        }
        this.binaryDVUpdates = allBinaryUpdates.toArray(new DocValuesUpdate.BinaryDocValuesUpdate[allBinaryUpdates.size()]);
        this.bytesUsed = (int)(this.terms.ramBytesUsed() + (long)(this.queries.length * BYTES_PER_DEL_QUERY) + (long)numericUpdatesSize + RamUsageEstimator.shallowSizeOf(this.numericDVUpdates) + (long)binaryUpdatesSize + RamUsageEstimator.shallowSizeOf(this.binaryDVUpdates));
        this.numTermDeletes = deletes.numTermDeletes.get();
    }

    public void setDelGen(long gen) {
        assert (this.gen == -1L);
        this.gen = gen;
        this.terms.setDelGen(gen);
    }

    public long delGen() {
        assert (this.gen != -1L);
        return this.gen;
    }

    public PrefixCodedTerms.TermIterator termIterator() {
        return this.terms.iterator();
    }

    public Iterable<BufferedUpdatesStream.QueryAndLimit> queriesIterable() {
        return new Iterable<BufferedUpdatesStream.QueryAndLimit>(){

            @Override
            public Iterator<BufferedUpdatesStream.QueryAndLimit> iterator() {
                return new Iterator<BufferedUpdatesStream.QueryAndLimit>(){
                    private int upto;

                    @Override
                    public boolean hasNext() {
                        return this.upto < FrozenBufferedUpdates.this.queries.length;
                    }

                    @Override
                    public BufferedUpdatesStream.QueryAndLimit next() {
                        BufferedUpdatesStream.QueryAndLimit ret = new BufferedUpdatesStream.QueryAndLimit(FrozenBufferedUpdates.this.queries[this.upto], FrozenBufferedUpdates.this.queryLimits[this.upto]);
                        ++this.upto;
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String toString() {
        String s = "";
        if (this.numTermDeletes != 0) {
            s = s + " " + this.numTermDeletes + " deleted terms (unique count=" + this.terms.size() + ")";
        }
        if (this.queries.length != 0) {
            s = s + " " + this.queries.length + " deleted queries";
        }
        if (this.bytesUsed != 0) {
            s = s + " bytesUsed=" + this.bytesUsed;
        }
        return s;
    }

    boolean any() {
        return this.terms.size() > 0L || this.queries.length > 0 || this.numericDVUpdates.length > 0 || this.binaryDVUpdates.length > 0;
    }
}

