/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public abstract class AbstractAnalysisFactory {
    public static final String LUCENE_MATCH_VERSION_PARAM = "luceneMatchVersion";
    private final Map<String, String> originalArgs;
    protected final Version luceneMatchVersion;
    private boolean isExplicitLuceneMatchVersion = false;
    private static final Pattern ITEM_PATTERN = Pattern.compile("[^,\\s]+");
    private static final String CLASS_NAME = "class";

    protected AbstractAnalysisFactory(Map<String, String> args) {
        this.originalArgs = Collections.unmodifiableMap(new HashMap<String, String>(args));
        String version2 = this.get(args, LUCENE_MATCH_VERSION_PARAM);
        if (version2 == null) {
            this.luceneMatchVersion = Version.LATEST;
        } else {
            try {
                this.luceneMatchVersion = Version.parseLeniently(version2);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(pe);
            }
        }
        args.remove(CLASS_NAME);
    }

    public final Map<String, String> getOriginalArgs() {
        return this.originalArgs;
    }

    public final Version getLuceneMatchVersion() {
        return this.luceneMatchVersion;
    }

    public String require(Map<String, String> args, String name2) {
        String s = args.remove(name2);
        if (s == null) {
            throw new IllegalArgumentException("Configuration Error: missing parameter '" + name2 + "'");
        }
        return s;
    }

    public String require(Map<String, String> args, String name2, Collection<String> allowedValues) {
        return this.require(args, name2, allowedValues, true);
    }

    public String require(Map<String, String> args, String name2, Collection<String> allowedValues, boolean caseSensitive) {
        String s = args.remove(name2);
        if (s == null) {
            throw new IllegalArgumentException("Configuration Error: missing parameter '" + name2 + "'");
        }
        for (String allowedValue : allowedValues) {
            if (!(caseSensitive ? s.equals(allowedValue) : s.equalsIgnoreCase(allowedValue))) continue;
            return s;
        }
        throw new IllegalArgumentException("Configuration Error: '" + name2 + "' value must be one of " + allowedValues);
    }

    public String get(Map<String, String> args, String name2) {
        return args.remove(name2);
    }

    public String get(Map<String, String> args, String name2, String defaultVal) {
        String s = args.remove(name2);
        return s == null ? defaultVal : s;
    }

    public String get(Map<String, String> args, String name2, Collection<String> allowedValues) {
        return this.get(args, name2, allowedValues, null);
    }

    public String get(Map<String, String> args, String name2, Collection<String> allowedValues, String defaultVal) {
        return this.get(args, name2, allowedValues, defaultVal, true);
    }

    public String get(Map<String, String> args, String name2, Collection<String> allowedValues, String defaultVal, boolean caseSensitive) {
        String s = args.remove(name2);
        if (s == null) {
            return defaultVal;
        }
        for (String allowedValue : allowedValues) {
            if (!(caseSensitive ? s.equals(allowedValue) : s.equalsIgnoreCase(allowedValue))) continue;
            return s;
        }
        throw new IllegalArgumentException("Configuration Error: '" + name2 + "' value must be one of " + allowedValues);
    }

    protected final int requireInt(Map<String, String> args, String name2) {
        return Integer.parseInt(this.require(args, name2));
    }

    protected final int getInt(Map<String, String> args, String name2, int defaultVal) {
        String s = args.remove(name2);
        return s == null ? defaultVal : Integer.parseInt(s);
    }

    protected final boolean requireBoolean(Map<String, String> args, String name2) {
        return Boolean.parseBoolean(this.require(args, name2));
    }

    protected final boolean getBoolean(Map<String, String> args, String name2, boolean defaultVal) {
        String s = args.remove(name2);
        return s == null ? defaultVal : Boolean.parseBoolean(s);
    }

    protected final float requireFloat(Map<String, String> args, String name2) {
        return Float.parseFloat(this.require(args, name2));
    }

    protected final float getFloat(Map<String, String> args, String name2, float defaultVal) {
        String s = args.remove(name2);
        return s == null ? defaultVal : Float.parseFloat(s);
    }

    public char requireChar(Map<String, String> args, String name2) {
        return this.require(args, name2).charAt(0);
    }

    public char getChar(Map<String, String> args, String name2, char defaultValue) {
        String s = args.remove(name2);
        if (s == null) {
            return defaultValue;
        }
        if (s.length() != 1) {
            throw new IllegalArgumentException(name2 + " should be a char. \"" + s + "\" is invalid");
        }
        return s.charAt(0);
    }

    public Set<String> getSet(Map<String, String> args, String name2) {
        String s = args.remove(name2);
        if (s == null) {
            return null;
        }
        HashSet<String> set2 = null;
        Matcher matcher = ITEM_PATTERN.matcher(s);
        if (matcher.find()) {
            set2 = new HashSet<String>();
            set2.add(matcher.group(0));
            while (matcher.find()) {
                set2.add(matcher.group(0));
            }
        }
        return set2;
    }

    protected final Pattern getPattern(Map<String, String> args, String name2) {
        try {
            return Pattern.compile(this.require(args, name2));
        }
        catch (PatternSyntaxException e2) {
            throw new IllegalArgumentException("Configuration Error: '" + name2 + "' can not be parsed in " + this.getClass().getSimpleName(), e2);
        }
    }

    protected final CharArraySet getWordSet(ResourceLoader loader2, String wordFiles, boolean ignoreCase) throws IOException {
        List<String> files = this.splitFileNames(wordFiles);
        CharArraySet words = null;
        if (files.size() > 0) {
            words = new CharArraySet(files.size() * 10, ignoreCase);
            for (String file2 : files) {
                List<String> wlist = this.getLines(loader2, file2.trim());
                words.addAll(StopFilter.makeStopSet(wlist, ignoreCase));
            }
        }
        return words;
    }

    protected final List<String> getLines(ResourceLoader loader2, String resource2) throws IOException {
        return WordlistLoader.getLines(loader2.openResource(resource2), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CharArraySet getSnowballWordSet(ResourceLoader loader2, String wordFiles, boolean ignoreCase) throws IOException {
        List<String> files = this.splitFileNames(wordFiles);
        CharArraySet words = null;
        if (files.size() > 0) {
            words = new CharArraySet(files.size() * 10, ignoreCase);
            for (String file2 : files) {
                InputStream stream = null;
                InputStreamReader reader2 = null;
                try {
                    stream = loader2.openResource(file2.trim());
                    CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    reader2 = new InputStreamReader(stream, decoder);
                    WordlistLoader.getSnowballWordSet(reader2, words);
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException(reader2, stream);
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(reader2, stream);
            }
        }
        return words;
    }

    protected final List<String> splitFileNames(String fileNames) {
        if (fileNames == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String file2 : fileNames.split("(?<!\\\\),")) {
            result.add(file2.replaceAll("\\\\(?=,)", ""));
        }
        return result;
    }

    public String getClassArg() {
        String className;
        if (null != this.originalArgs && null != (className = this.originalArgs.get(CLASS_NAME))) {
            return className;
        }
        return this.getClass().getName();
    }

    public boolean isExplicitLuceneMatchVersion() {
        return this.isExplicitLuceneMatchVersion;
    }

    public void setExplicitLuceneMatchVersion(boolean isExplicitLuceneMatchVersion) {
        this.isExplicitLuceneMatchVersion = isExplicitLuceneMatchVersion;
    }
}

