/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.FilteringTokenFilter;

public final class LengthFilter
extends FilteringTokenFilter {
    private final int min;
    private final int max;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public LengthFilter(TokenStream in, int min2, int max2) {
        super(in);
        if (min2 < 0) {
            throw new IllegalArgumentException("minimum length must be greater than or equal to zero");
        }
        if (min2 > max2) {
            throw new IllegalArgumentException("maximum length must not be greater than minimum length");
        }
        this.min = min2;
        this.max = max2;
    }

    @Override
    public boolean accept() {
        int len = this.termAtt.length();
        return len >= this.min && len <= this.max;
    }
}

