/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpMessage;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;

@NotThreadSafe
public abstract class AbstractHttpMessage
implements HttpMessage {
    protected HeaderGroup headergroup = new HeaderGroup();
    @Deprecated
    protected HttpParams params;

    @Deprecated
    protected AbstractHttpMessage(HttpParams params) {
        this.params = params;
    }

    protected AbstractHttpMessage() {
        this(null);
    }

    @Override
    public boolean containsHeader(String name2) {
        return this.headergroup.containsHeader(name2);
    }

    @Override
    public Header[] getHeaders(String name2) {
        return this.headergroup.getHeaders(name2);
    }

    @Override
    public Header getFirstHeader(String name2) {
        return this.headergroup.getFirstHeader(name2);
    }

    @Override
    public Header getLastHeader(String name2) {
        return this.headergroup.getLastHeader(name2);
    }

    @Override
    public Header[] getAllHeaders() {
        return this.headergroup.getAllHeaders();
    }

    @Override
    public void addHeader(Header header) {
        this.headergroup.addHeader(header);
    }

    @Override
    public void addHeader(String name2, String value) {
        Args.notNull(name2, "Header name");
        this.headergroup.addHeader(new BasicHeader(name2, value));
    }

    @Override
    public void setHeader(Header header) {
        this.headergroup.updateHeader(header);
    }

    @Override
    public void setHeader(String name2, String value) {
        Args.notNull(name2, "Header name");
        this.headergroup.updateHeader(new BasicHeader(name2, value));
    }

    @Override
    public void setHeaders(Header[] headers) {
        this.headergroup.setHeaders(headers);
    }

    @Override
    public void removeHeader(Header header) {
        this.headergroup.removeHeader(header);
    }

    @Override
    public void removeHeaders(String name2) {
        if (name2 == null) {
            return;
        }
        HeaderIterator i = this.headergroup.iterator();
        while (i.hasNext()) {
            Header header = i.nextHeader();
            if (!name2.equalsIgnoreCase(header.getName())) continue;
            i.remove();
        }
    }

    @Override
    public HeaderIterator headerIterator() {
        return this.headergroup.iterator();
    }

    @Override
    public HeaderIterator headerIterator(String name2) {
        return this.headergroup.iterator(name2);
    }

    @Override
    @Deprecated
    public HttpParams getParams() {
        if (this.params == null) {
            this.params = new BasicHttpParams();
        }
        return this.params;
    }

    @Override
    @Deprecated
    public void setParams(HttpParams params) {
        this.params = Args.notNull(params, "HTTP parameters");
    }
}

