/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io.jts;

import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.io.WktShapeParser;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JtsWktShapeParser
extends WktShapeParser {
    protected final JtsSpatialContext ctx;
    protected final DatelineRule datelineRule;
    protected final ValidationRule validationRule;
    protected final boolean autoIndex;

    public JtsWktShapeParser(JtsSpatialContext ctx, JtsSpatialContextFactory factory) {
        super(ctx, factory);
        this.ctx = ctx;
        this.datelineRule = factory.datelineRule;
        this.validationRule = factory.validationRule;
        this.autoIndex = factory.autoIndex;
    }

    public ValidationRule getValidationRule() {
        return this.validationRule;
    }

    public boolean isAutoValidate() {
        return this.validationRule != ValidationRule.none;
    }

    public boolean isAutoIndex() {
        return this.autoIndex;
    }

    public DatelineRule getDatelineRule() {
        return this.datelineRule;
    }

    @Override
    protected Shape parseShapeByType(WktShapeParser.State state, String shapeType) throws ParseException {
        if (shapeType.equalsIgnoreCase("POLYGON")) {
            return this.parsePolygonShape(state);
        }
        if (shapeType.equalsIgnoreCase("MULTIPOLYGON")) {
            return this.parseMulitPolygonShape(state);
        }
        return super.parseShapeByType(state, shapeType);
    }

    @Override
    protected Shape parseLineStringShape(WktShapeParser.State state) throws ParseException {
        if (!this.ctx.useJtsLineString()) {
            return super.parseLineStringShape(state);
        }
        if (state.nextIfEmptyAndSkipZM()) {
            return this.ctx.makeLineString(Collections.<Point>emptyList());
        }
        GeometryFactory geometryFactory = this.ctx.getGeometryFactory();
        Coordinate[] coordinates = this.coordinateSequence(state);
        return this.makeShapeFromGeometry((Geometry)geometryFactory.createLineString(coordinates));
    }

    protected Shape parsePolygonShape(WktShapeParser.State state) throws ParseException {
        Polygon geometry;
        if (state.nextIfEmptyAndSkipZM()) {
            GeometryFactory geometryFactory = this.ctx.getGeometryFactory();
            geometry = geometryFactory.createPolygon(geometryFactory.createLinearRing(new Coordinate[0]), null);
        } else {
            geometry = this.polygon(state);
            if (geometry.isRectangle()) {
                return this.makeRectFromPoly((Geometry)geometry);
            }
        }
        return this.makeShapeFromGeometry((Geometry)geometry);
    }

    protected Rectangle makeRectFromPoly(Geometry geometry) {
        assert (geometry.isRectangle());
        Envelope env = geometry.getEnvelopeInternal();
        boolean crossesDateline = false;
        if (this.ctx.isGeo() && this.getDatelineRule() != DatelineRule.none) {
            if (this.getDatelineRule() == DatelineRule.ccwRect) {
                crossesDateline = !CGAlgorithms.isCCW((Coordinate[])geometry.getCoordinates());
            } else {
                boolean bl = crossesDateline = env.getWidth() > 180.0;
            }
        }
        if (crossesDateline) {
            return this.ctx.makeRectangle(env.getMaxX(), env.getMinX(), env.getMinY(), env.getMaxY());
        }
        return this.ctx.makeRectangle(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY());
    }

    protected Polygon polygon(WktShapeParser.State state) throws ParseException {
        GeometryFactory geometryFactory = this.ctx.getGeometryFactory();
        List<Coordinate[]> coordinateSequenceList = this.coordinateSequenceList(state);
        LinearRing shell2 = geometryFactory.createLinearRing(coordinateSequenceList.get(0));
        LinearRing[] holes = null;
        if (coordinateSequenceList.size() > 1) {
            holes = new LinearRing[coordinateSequenceList.size() - 1];
            for (int i = 1; i < coordinateSequenceList.size(); ++i) {
                holes[i - 1] = geometryFactory.createLinearRing(coordinateSequenceList.get(i));
            }
        }
        return geometryFactory.createPolygon(shell2, holes);
    }

    protected Shape parseMulitPolygonShape(WktShapeParser.State state) throws ParseException {
        if (state.nextIfEmptyAndSkipZM()) {
            return this.ctx.makeCollection(Collections.EMPTY_LIST);
        }
        ArrayList<Shape> polygons = new ArrayList<Shape>();
        state.nextExpect('(');
        do {
            polygons.add(this.parsePolygonShape(state));
        } while (state.nextIf(','));
        state.nextExpect(')');
        return this.ctx.makeCollection(polygons);
    }

    protected List<Coordinate[]> coordinateSequenceList(WktShapeParser.State state) throws ParseException {
        ArrayList<Coordinate[]> sequenceList = new ArrayList<Coordinate[]>();
        state.nextExpect('(');
        do {
            sequenceList.add(this.coordinateSequence(state));
        } while (state.nextIf(','));
        state.nextExpect(')');
        return sequenceList;
    }

    protected Coordinate[] coordinateSequence(WktShapeParser.State state) throws ParseException {
        ArrayList<Coordinate> sequence2 = new ArrayList<Coordinate>();
        state.nextExpect('(');
        do {
            sequence2.add(this.coordinate(state));
        } while (state.nextIf(','));
        state.nextExpect(')');
        return sequence2.toArray(new Coordinate[sequence2.size()]);
    }

    protected Coordinate coordinate(WktShapeParser.State state) throws ParseException {
        double x = this.ctx.normX(state.nextDouble());
        this.ctx.verifyX(x);
        double y = this.ctx.normY(state.nextDouble());
        this.ctx.verifyY(y);
        state.skipNextDoubles();
        return new Coordinate(x, y);
    }

    @Override
    protected double normDist(double v) {
        return this.ctx.getGeometryFactory().getPrecisionModel().makePrecise(v);
    }

    protected JtsGeometry makeShapeFromGeometry(Geometry geometry) {
        JtsGeometry jtsGeom;
        boolean dateline180Check = this.getDatelineRule() != DatelineRule.none;
        try {
            jtsGeom = this.ctx.makeShape(geometry, dateline180Check, this.ctx.isAllowMultiOverlap());
            if (this.isAutoValidate()) {
                jtsGeom.validate();
            }
        }
        catch (RuntimeException e2) {
            if (this.validationRule == ValidationRule.repairConvexHull) {
                jtsGeom = this.ctx.makeShape(geometry.convexHull(), dateline180Check, this.ctx.isAllowMultiOverlap());
            }
            if (this.validationRule == ValidationRule.repairBuffer0) {
                jtsGeom = this.ctx.makeShape(geometry.buffer(0.0), dateline180Check, this.ctx.isAllowMultiOverlap());
            }
            throw e2;
        }
        if (this.isAutoIndex()) {
            jtsGeom.index();
        }
        return jtsGeom;
    }

    public static enum ValidationRule {
        none,
        error,
        repairConvexHull,
        repairBuffer0;

    }

    public static enum DatelineRule {
        none,
        width180,
        ccwRect;

    }
}

