/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdUtils;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFDatasetUtils;
import com.github.jsonldjava.core.UniqueNamer;
import com.github.jsonldjava.utils.Obj;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class NormalizeUtils {
    private final UniqueNamer namer;
    private final Map<String, Object> bnodes;
    private final List<Object> quads;
    private final JsonLdOptions options;

    public NormalizeUtils(List<Object> quads, Map<String, Object> bnodes, UniqueNamer namer, JsonLdOptions options) {
        this.options = options;
        this.quads = quads;
        this.bnodes = bnodes;
        this.namer = namer;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Object hashBlankNodes(Collection<String> unnamed_) throws JsonLdError {
        ArrayList hashes;
        ArrayList<String> arrayList = new ArrayList<String>(unnamed_);
        ArrayList<String> nextUnnamed = new ArrayList<String>();
        LinkedHashMap duplicates = new LinkedHashMap();
        LinkedHashMap<String, String> unique = new LinkedHashMap<String, String>();
        int hui = 0;
        while (true) {
            void var2_3;
            if (hui == var2_3.size()) {
                Boolean named = false;
                hashes = new ArrayList(unique.keySet());
                Collections.sort(hashes);
                for (String hash2 : hashes) {
                    String bnode = (String)unique.get(hash2);
                    this.namer.getName(bnode);
                    named = true;
                }
                if (!named.booleanValue()) break;
                hui = -1;
                ArrayList<String> arrayList2 = nextUnnamed;
                nextUnnamed = new ArrayList();
                duplicates = new LinkedHashMap();
                unique = new LinkedHashMap();
            } else {
                String bnode = (String)var2_3.get(hui);
                String hash3 = NormalizeUtils.hashQuads(bnode, this.bnodes, this.namer);
                if (duplicates.containsKey(hash3)) {
                    ((List)duplicates.get(hash3)).add(bnode);
                    nextUnnamed.add(bnode);
                } else if (unique.containsKey(hash3)) {
                    ArrayList<Object> tmp = new ArrayList<Object>();
                    tmp.add(unique.get(hash3));
                    tmp.add(bnode);
                    duplicates.put(hash3, tmp);
                    nextUnnamed.add((String)unique.get(hash3));
                    nextUnnamed.add(bnode);
                    unique.remove(hash3);
                } else {
                    unique.put(hash3, bnode);
                }
            }
            ++hui;
        }
        hashes = new ArrayList(duplicates.keySet());
        Collections.sort(hashes);
        int pgi = 0;
        while (true) {
            if (pgi == hashes.size()) {
                Iterator quad;
                ArrayList<String> normalized = new ArrayList<String>();
                for (int cai = 0; cai < this.quads.size(); ++cai) {
                    quad = (Map)this.quads.get(cai);
                    for (String attr : new String[]{"subject", "object", "name"}) {
                        Map qa;
                        if (!quad.containsKey(attr) || (qa = (Map)quad.get(attr)) == null || !"blank node".equals(qa.get("type")) || ((String)qa.get("value")).indexOf("_:c14n") == 0) continue;
                        qa.put("value", this.namer.getName((String)qa.get("value")));
                    }
                    normalized.add(RDFDatasetUtils.toNQuad((RDFDataset.Quad)((Object)quad), quad.containsKey("name") && quad.get("name") != null ? (String)((Map)quad.get("name")).get("value") : null));
                }
                Collections.sort(normalized);
                if (this.options.format != null) {
                    if (!"application/nquads".equals(this.options.format)) {
                        throw new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT, this.options.format);
                    }
                    StringBuilder rval = new StringBuilder();
                    quad = normalized.iterator();
                    while (true) {
                        if (!quad.hasNext()) {
                            return rval.toString();
                        }
                        String string2 = (String)quad.next();
                        rval.append(string2);
                    }
                }
                StringBuilder rval = new StringBuilder();
                quad = normalized.iterator();
                while (true) {
                    if (!quad.hasNext()) {
                        return RDFDatasetUtils.parseNQuads(rval.toString());
                    }
                    String string3 = (String)quad.next();
                    rval.append(string3);
                }
            }
            List group = (List)duplicates.get(hashes.get(pgi));
            ArrayList<HashResult> results = new ArrayList<HashResult>();
            int n = 0;
            while (true) {
                if (n == group.size()) {
                    Collections.sort(results, new Comparator<HashResult>(){

                        @Override
                        public int compare(HashResult a, HashResult b) {
                            int res = a.hash.compareTo(b.hash);
                            return res;
                        }
                    });
                    for (HashResult r : results) {
                        for (String key2 : r.pathNamer.existing().keySet()) {
                            this.namer.getName(key2);
                        }
                    }
                    break;
                }
                String string4 = (String)group.get(n);
                if (!this.namer.isNamed(string4).booleanValue()) {
                    UniqueNamer pathNamer = new UniqueNamer("_:b");
                    pathNamer.getName(string4);
                    HashResult result = NormalizeUtils.hashPaths(string4, this.bnodes, this.namer, pathNamer);
                    results.add(result);
                }
                ++n;
            }
            ++pgi;
        }
    }

    private static HashResult hashPaths(String id, Map<String, Object> bnodes, UniqueNamer namer, UniqueNamer pathNamer) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            LinkedHashMap groups = new LinkedHashMap();
            List quads = (List)((Map)bnodes.get(id)).get("quads");
            int hpi = 0;
            while (true) {
                if (hpi == quads.size()) {
                    ArrayList groupHashes = new ArrayList(groups.keySet());
                    Collections.sort(groupHashes);
                    int hgi = 0;
                    while (true) {
                        if (hgi == groupHashes.size()) {
                            HashResult res = new HashResult();
                            res.hash = NormalizeUtils.encodeHex(md.digest());
                            res.pathNamer = pathNamer;
                            return res;
                        }
                        String groupHash = (String)groupHashes.get(hgi);
                        md.update(groupHash.getBytes("UTF-8"));
                        String chosenPath = null;
                        UniqueNamer chosenNamer = null;
                        Permutator permutator = new Permutator((List)groups.get(groupHash));
                        while (true) {
                            Boolean contPermutation = false;
                            Boolean breakOut = false;
                            List<String> permutation = permutator.next();
                            UniqueNamer pathNamerCopy = pathNamer.clone();
                            String path2 = "";
                            ArrayList<String> recurse = new ArrayList<String>();
                            for (String bnode : permutation) {
                                if (namer.isNamed(bnode).booleanValue()) {
                                    path2 = path2 + namer.getName(bnode);
                                } else {
                                    if (!pathNamerCopy.isNamed(bnode).booleanValue()) {
                                        recurse.add(bnode);
                                    }
                                    path2 = path2 + pathNamerCopy.getName(bnode);
                                }
                                if (chosenPath == null || path2.length() < chosenPath.length() || path2.compareTo(chosenPath) <= 0) continue;
                                if (permutator.hasNext()) {
                                    contPermutation = true;
                                    break;
                                }
                                md.update(chosenPath.getBytes("UTF-8"));
                                pathNamer = chosenNamer;
                                breakOut = true;
                                break;
                            }
                            if (contPermutation.booleanValue()) continue;
                            if (breakOut.booleanValue()) break;
                            int nrn = 0;
                            while (true) {
                                String bnode;
                                if (nrn == recurse.size()) {
                                    if (chosenPath == null || path2.compareTo(chosenPath) < 0) {
                                        chosenPath = path2;
                                        chosenNamer = pathNamerCopy;
                                    }
                                    if (permutator.hasNext()) break;
                                    md.update(chosenPath.getBytes("UTF-8"));
                                    pathNamer = chosenNamer;
                                    breakOut = true;
                                    break;
                                }
                                bnode = (String)recurse.get(nrn);
                                HashResult result = NormalizeUtils.hashPaths(bnode, bnodes, namer, pathNamerCopy);
                                path2 = path2 + pathNamerCopy.getName(bnode) + "<" + result.hash + ">";
                                pathNamerCopy = result.pathNamer;
                                if (chosenPath != null && path2.length() >= chosenPath.length() && path2.compareTo(chosenPath) > 0) {
                                    if (permutator.hasNext()) break;
                                    md.update(chosenPath.getBytes("UTF-8"));
                                    pathNamer = chosenNamer;
                                    breakOut = true;
                                    break;
                                }
                                ++nrn;
                            }
                            if (breakOut.booleanValue()) break;
                        }
                        ++hgi;
                    }
                }
                Map quad = (Map)quads.get(hpi);
                String bnode = NormalizeUtils.getAdjacentBlankNodeName((Map)quad.get("subject"), id);
                String direction = null;
                if (bnode != null) {
                    direction = "p";
                } else {
                    bnode = NormalizeUtils.getAdjacentBlankNodeName((Map)quad.get("object"), id);
                    if (bnode != null) {
                        direction = "r";
                    }
                }
                if (bnode != null) {
                    String name2 = namer.isNamed(bnode) != false ? namer.getName(bnode) : (pathNamer.isNamed(bnode) != false ? pathNamer.getName(bnode) : NormalizeUtils.hashQuads(bnode, bnodes, namer));
                    MessageDigest md1 = MessageDigest.getInstance("SHA-1");
                    md1.update(direction.getBytes("UTF-8"));
                    md1.update(((String)((Map)quad.get("predicate")).get("value")).getBytes("UTF-8"));
                    md1.update(name2.getBytes("UTF-8"));
                    String groupHash = NormalizeUtils.encodeHex(md1.digest());
                    if (groups.containsKey(groupHash)) {
                        ((List)groups.get(groupHash)).add(bnode);
                    } else {
                        ArrayList<String> tmp = new ArrayList<String>();
                        tmp.add(bnode);
                        groups.put(groupHash, tmp);
                    }
                }
                ++hpi;
            }
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
        catch (UnsupportedEncodingException e3) {
            throw new RuntimeException(e3);
        }
    }

    private static String hashQuads(String id, Map<String, Object> bnodes, UniqueNamer namer) {
        if (((Map)bnodes.get(id)).containsKey("hash")) {
            return (String)((Map)bnodes.get(id)).get("hash");
        }
        List quads = (List)((Map)bnodes.get(id)).get("quads");
        ArrayList<String> nquads = new ArrayList<String>();
        for (int i = 0; i < quads.size(); ++i) {
            nquads.add(RDFDatasetUtils.toNQuad((RDFDataset.Quad)quads.get(i), ((Map)quads.get(i)).get("name") != null ? (String)((Map)((Map)quads.get(i)).get("name")).get("value") : null, id));
        }
        Collections.sort(nquads);
        String hash2 = NormalizeUtils.sha1hash(nquads);
        ((Map)bnodes.get(id)).put("hash", hash2);
        return hash2;
    }

    private static String sha1hash(Collection<String> nquads) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            for (String nquad : nquads) {
                md.update(nquad.getBytes("UTF-8"));
            }
            return NormalizeUtils.encodeHex(md.digest());
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
        catch (UnsupportedEncodingException e3) {
            throw new RuntimeException(e3);
        }
    }

    private static String encodeHex(byte[] data2) {
        String rval = "";
        for (byte b : data2) {
            rval = rval + String.format("%02x", b);
        }
        return rval;
    }

    private static String getAdjacentBlankNodeName(Map<String, Object> node2, String id) {
        return "blank node".equals(node2.get("type")) && (!node2.containsKey("value") || !Obj.equals(node2.get("value"), id)) ? (String)node2.get("value") : null;
    }

    private static class Permutator {
        private final List<String> list;
        private boolean done;
        private final Map<String, Boolean> left;

        public Permutator(List<String> list) {
            this.list = (List)JsonLdUtils.clone(list);
            Collections.sort(this.list);
            this.done = false;
            this.left = new LinkedHashMap<String, Boolean>();
            for (String i : this.list) {
                this.left.put(i, true);
            }
        }

        public boolean hasNext() {
            return !this.done;
        }

        public List<String> next() {
            List rval = (List)JsonLdUtils.clone(this.list);
            String k = null;
            int pos = 0;
            int length = this.list.size();
            for (int i = 0; i < length; ++i) {
                String element = this.list.get(i);
                Boolean left2 = this.left.get(element);
                if (k != null && element.compareTo(k) <= 0 || (!left2.booleanValue() || i <= 0 || element.compareTo(this.list.get(i - 1)) <= 0) && (left2.booleanValue() || i >= length - 1 || element.compareTo(this.list.get(i + 1)) <= 0)) continue;
                k = element;
                pos = i;
            }
            if (k == null) {
                this.done = true;
            } else {
                int swap = this.left.get(k) != false ? pos - 1 : pos + 1;
                this.list.set(pos, this.list.get(swap));
                this.list.set(swap, k);
                for (int i = 0; i < length; ++i) {
                    if (this.list.get(i).compareTo(k) <= 0) continue;
                    this.left.put(this.list.get(i), this.left.get(this.list.get(i)) == false);
                }
            }
            return rval;
        }
    }

    private static class HashResult {
        String hash;
        UniqueNamer pathNamer;

        private HashResult() {
        }
    }
}

