/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.util.TypeKey;
import java.util.HashMap;
import java.util.Map;

public final class ReadOnlyClassToSerializerMap {
    private final Bucket[] _buckets;
    private final int _size;
    private final int _mask;

    public ReadOnlyClassToSerializerMap(Map<TypeKey, JsonSerializer<Object>> serializers) {
        int size;
        this._size = size = ReadOnlyClassToSerializerMap.findSize(serializers.size());
        this._mask = size - 1;
        Bucket[] buckets = new Bucket[size];
        for (Map.Entry<TypeKey, JsonSerializer<Object>> entry : serializers.entrySet()) {
            TypeKey key2 = entry.getKey();
            int index2 = key2.hashCode() & this._mask;
            buckets[index2] = new Bucket(buckets[index2], key2, entry.getValue());
        }
        this._buckets = buckets;
    }

    private static final int findSize(int size) {
        int result;
        int needed = size <= 64 ? size + size : size + (size >> 2);
        for (result = 8; result < needed; result += result) {
        }
        return result;
    }

    public static ReadOnlyClassToSerializerMap from(HashMap<TypeKey, JsonSerializer<Object>> src) {
        return new ReadOnlyClassToSerializerMap(src);
    }

    public int size() {
        return this._size;
    }

    public JsonSerializer<Object> typedValueSerializer(JavaType type2) {
        Bucket bucket = this._buckets[TypeKey.typedHash(type2) & this._mask];
        if (bucket == null) {
            return null;
        }
        if (bucket.matchesTyped(type2)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!bucket.matchesTyped(type2)) continue;
            return bucket.value;
        }
        return null;
    }

    public JsonSerializer<Object> typedValueSerializer(Class<?> type2) {
        Bucket bucket = this._buckets[TypeKey.typedHash(type2) & this._mask];
        if (bucket == null) {
            return null;
        }
        if (bucket.matchesTyped(type2)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!bucket.matchesTyped(type2)) continue;
            return bucket.value;
        }
        return null;
    }

    public JsonSerializer<Object> untypedValueSerializer(JavaType type2) {
        Bucket bucket = this._buckets[TypeKey.untypedHash(type2) & this._mask];
        if (bucket == null) {
            return null;
        }
        if (bucket.matchesUntyped(type2)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!bucket.matchesUntyped(type2)) continue;
            return bucket.value;
        }
        return null;
    }

    public JsonSerializer<Object> untypedValueSerializer(Class<?> type2) {
        Bucket bucket = this._buckets[TypeKey.untypedHash(type2) & this._mask];
        if (bucket == null) {
            return null;
        }
        if (bucket.matchesUntyped(type2)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!bucket.matchesUntyped(type2)) continue;
            return bucket.value;
        }
        return null;
    }

    private static final class Bucket {
        public final JsonSerializer<Object> value;
        public final Bucket next;
        protected final Class<?> _class;
        protected final JavaType _type;
        protected final boolean _isTyped;

        public Bucket(Bucket next2, TypeKey key2, JsonSerializer<Object> value) {
            this.next = next2;
            this.value = value;
            this._isTyped = key2.isTyped();
            this._class = key2.getRawType();
            this._type = key2.getType();
        }

        public boolean matchesTyped(Class<?> key2) {
            return this._class == key2 && this._isTyped;
        }

        public boolean matchesUntyped(Class<?> key2) {
            return this._class == key2 && !this._isTyped;
        }

        public boolean matchesTyped(JavaType key2) {
            return this._isTyped && key2.equals(this._type);
        }

        public boolean matchesUntyped(JavaType key2) {
            return !this._isTyped && key2.equals(this._type);
        }
    }
}

