/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailClosable;

abstract class SailClosingIteration<T, X extends Exception>
extends IterationWrapper<T, X> {
    private final SailClosable[] closes;

    public static <E> SailClosingIteration<E, SailException> makeClosable(CloseableIteration<? extends E, SailException> iter, SailClosable ... closes) {
        return new SailClosingIteration<E, SailException>(iter, closes){

            @Override
            protected void handleSailException(SailException e2) throws SailException {
                throw e2;
            }
        };
    }

    public SailClosingIteration(CloseableIteration<? extends T, X> iter, SailClosable ... closes) {
        super(iter);
        this.closes = closes;
    }

    @Override
    public boolean hasNext() throws X {
        if (this.isClosed()) {
            return false;
        }
        boolean result = super.hasNext();
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public T next() throws X {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        try {
            return (T)super.next();
        }
        catch (NoSuchElementException e2) {
            this.close();
            throw e2;
        }
    }

    @Override
    public void remove() throws X {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        try {
            super.remove();
        }
        catch (IllegalStateException e2) {
            this.close();
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            ArrayList<SailException> exceptions = new ArrayList<SailException>();
            ArrayList<Throwable> extraOrdinaryExceptions = new ArrayList<Throwable>();
            for (SailClosable closing : this.closes) {
                try {
                    closing.close();
                }
                catch (SailException e2) {
                    exceptions.add(e2);
                }
                catch (Throwable e3) {
                    extraOrdinaryExceptions.add(e3);
                }
            }
            for (SailException nextException : exceptions) {
                this.handleSailException(nextException);
            }
            if (!extraOrdinaryExceptions.isEmpty()) {
                throw new UndeclaredThrowableException((Throwable)extraOrdinaryExceptions.get(0));
            }
        }
    }

    protected abstract void handleSailException(SailException var1) throws X;
}

