/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.sparqlxml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.xml.SimpleSAXAdapter;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.xml.sax.SAXException;

class SPARQLResultsSAXParser
extends SimpleSAXAdapter {
    private List<String> bindingNames;
    private String currentBindingName;
    private Value currentValue;
    private MapBindingSet currentSolution;
    private ValueFactory valueFactory;
    private QueryResultHandler handler;

    public SPARQLResultsSAXParser(ValueFactory valueFactory, QueryResultHandler handler) {
        this.valueFactory = valueFactory;
        this.handler = handler;
    }

    @Override
    public void startDocument() throws SAXException {
        this.bindingNames = new ArrayList<String>();
        this.currentValue = null;
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (this.handler != null) {
                this.handler.endQueryResult();
            }
        }
        catch (TupleQueryResultHandlerException e2) {
            throw new SAXException(e2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startTag(String tagName, Map<String, String> atts, String text) throws SAXException {
        if ("binding".equals(tagName)) {
            this.currentBindingName = atts.get("name");
            if (this.currentBindingName != null) return;
            throw new SAXException("name attribute missing for binding element");
        }
        if ("uri".equals(tagName)) {
            try {
                this.currentValue = this.valueFactory.createIRI(text);
                return;
            }
            catch (IllegalArgumentException e2) {
                throw new SAXException(e2.getMessage(), e2);
            }
        } else if ("bnode".equals(tagName)) {
            this.currentValue = this.valueFactory.createBNode(text);
            return;
        } else if ("literal".equals(tagName)) {
            String xmlLang = atts.get("xml:lang");
            String datatype = atts.get("datatype");
            if (xmlLang != null) {
                this.currentValue = this.valueFactory.createLiteral(text, xmlLang);
                return;
            } else if (datatype != null) {
                try {
                    this.currentValue = this.valueFactory.createLiteral(text, this.valueFactory.createIRI(datatype));
                    return;
                }
                catch (IllegalArgumentException e3) {
                    throw new SAXException(e3.getMessage(), e3);
                }
            } else {
                this.currentValue = this.valueFactory.createLiteral(text);
            }
            return;
        } else if ("result".equals(tagName)) {
            this.currentSolution = new MapBindingSet(this.bindingNames.size());
            return;
        } else if ("variable".equals(tagName)) {
            String varName = atts.get("name");
            if (varName == null) {
                throw new SAXException("name missing for variable element");
            }
            this.bindingNames.add(varName);
            return;
        } else if ("results".equals(tagName)) {
            try {
                if (this.handler == null) return;
                this.handler.startQueryResult(this.bindingNames);
                return;
            }
            catch (TupleQueryResultHandlerException e4) {
                throw new SAXException(e4);
            }
        } else {
            if (!"boolean".equals(tagName)) return;
            QueryResultParseException realException = new QueryResultParseException("Found boolean results in tuple parser");
            throw new SAXException(realException);
        }
    }

    @Override
    public void endTag(String tagName) throws SAXException {
        if ("binding".equals(tagName)) {
            if (this.currentValue == null) {
                throw new SAXException("Value missing for binding element");
            }
            this.currentSolution.addBinding(this.currentBindingName, this.currentValue);
            this.currentBindingName = null;
            this.currentValue = null;
        } else if ("result".equals(tagName)) {
            try {
                if (this.handler != null) {
                    this.handler.handleSolution(this.currentSolution);
                }
                this.currentSolution = null;
            }
            catch (TupleQueryResultHandlerException e2) {
                throw new SAXException(e2);
            }
        }
    }
}

