/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.impl;

import java.io.Serializable;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.Dataset;

public class FallbackDataset
implements Dataset,
Serializable {
    private static final long serialVersionUID = 5866540736738270376L;
    private Dataset primary;
    private Dataset fallback;

    public static Dataset fallback(Dataset primary, Dataset fallback) {
        if (primary == null) {
            return fallback;
        }
        if (fallback == null) {
            return primary;
        }
        return new FallbackDataset(primary, fallback);
    }

    private FallbackDataset(Dataset primary, Dataset secondary) {
        assert (primary != null);
        assert (secondary != null);
        this.primary = primary;
        this.fallback = secondary;
    }

    @Override
    public Set<IRI> getDefaultGraphs() {
        Set<IRI> set2 = this.primary.getDefaultGraphs();
        if (set2 == null || set2.isEmpty()) {
            return this.fallback.getDefaultGraphs();
        }
        return set2;
    }

    @Override
    public Set<IRI> getNamedGraphs() {
        Set<IRI> set2 = this.primary.getNamedGraphs();
        if (set2 == null || set2.isEmpty()) {
            return this.fallback.getNamedGraphs();
        }
        return set2;
    }

    @Override
    public IRI getDefaultInsertGraph() {
        IRI graph = this.primary.getDefaultInsertGraph();
        if (graph == null) {
            return this.fallback.getDefaultInsertGraph();
        }
        return graph;
    }

    @Override
    public Set<IRI> getDefaultRemoveGraphs() {
        Set<IRI> set2 = this.primary.getDefaultRemoveGraphs();
        if (set2 == null || set2.isEmpty()) {
            return this.fallback.getDefaultRemoveGraphs();
        }
        return set2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRI uri : this.getDefaultRemoveGraphs()) {
            sb.append("DELETE FROM ");
            this.appendURI(sb, uri);
        }
        sb.append("INSERT INTO ");
        this.appendURI(sb, this.getDefaultInsertGraph());
        for (IRI uri : this.getDefaultGraphs()) {
            sb.append("USING ");
            this.appendURI(sb, uri);
        }
        for (IRI uri : this.getNamedGraphs()) {
            sb.append("USING NAMED ");
            this.appendURI(sb, uri);
        }
        return sb.toString();
    }

    private void appendURI(StringBuilder sb, IRI uri) {
        String str2 = uri.toString();
        if (str2.length() > 50) {
            sb.append("<").append(str2, 0, 19).append("..");
            sb.append(str2, str2.length() - 29, str2.length()).append(">\n");
        } else {
            sb.append("<").append(uri).append(">\n");
        }
    }
}

