/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.util.UUIDable;

public class EvaluationStrategies {
    private static final Cache<UUID, EvaluationStrategy> registry = CacheBuilder.newBuilder().weakValues().build();

    public static final EvaluationStrategy get(UUID key2) {
        return registry.getIfPresent(key2);
    }

    public static final UUID getKey(EvaluationStrategy strategy) {
        ConcurrentMap<UUID, EvaluationStrategy> map2 = registry.asMap();
        for (UUID key2 : map2.keySet()) {
            if (strategy != map2.get(key2)) continue;
            return key2;
        }
        return null;
    }

    public static final UUID register(EvaluationStrategy strategy) {
        UUID key2;
        if (strategy instanceof UUIDable) {
            key2 = ((UUIDable)((Object)strategy)).getUUID();
            if (EvaluationStrategies.get(key2) == null) {
                registry.put(key2, strategy);
            }
        } else {
            key2 = EvaluationStrategies.getKey(strategy);
            if (key2 == null) {
                key2 = UUID.randomUUID();
                registry.put(key2, strategy);
            }
        }
        return key2;
    }

    private EvaluationStrategies() {
    }
}

