/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;

public class QueryContext {
    private static final String QUERY_PREPARER_ATTRIBUTE = QueryPreparer.class.getName();
    private static final ThreadLocal<QueryContext> queryContext = new ThreadLocal();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private QueryContext previous;

    public static QueryContext getQueryContext() {
        return queryContext.get();
    }

    public QueryContext() {
    }

    public QueryContext(QueryPreparer qp) {
        this.setAttribute(QUERY_PREPARER_ATTRIBUTE, qp);
    }

    public void begin() {
        this.previous = queryContext.get();
        queryContext.set(this);
    }

    public QueryPreparer getQueryPreparer() {
        return (QueryPreparer)this.getAttribute(QUERY_PREPARER_ATTRIBUTE);
    }

    public void setAttribute(String name2, Object value) {
        this.attributes.put(name2, value);
    }

    public <T> T getAttribute(String name2) {
        return (T)this.attributes.get(name2);
    }

    public void end() {
        queryContext.remove();
        if (this.previous != null) {
            queryContext.set(this.previous);
        }
    }
}

