/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class QueryLanguage {
    public static final QueryLanguage SERQL = new QueryLanguage("SeRQL");
    public static final QueryLanguage SPARQL = new QueryLanguage("SPARQL");
    @Deprecated
    public static final QueryLanguage SERQO = new QueryLanguage("SeRQO");
    private static List<QueryLanguage> QUERY_LANGUAGES = new ArrayList<QueryLanguage>(4);
    private String name;

    public static Collection<QueryLanguage> values() {
        return Collections.unmodifiableList(QUERY_LANGUAGES);
    }

    public static QueryLanguage register(String name2) {
        QueryLanguage ql = new QueryLanguage(name2);
        QueryLanguage.register(ql);
        return ql;
    }

    public static void register(QueryLanguage ql) {
        QUERY_LANGUAGES.add(ql);
    }

    public static QueryLanguage valueOf(String qlName) {
        for (QueryLanguage ql : QUERY_LANGUAGES) {
            if (!ql.getName().equalsIgnoreCase(qlName)) continue;
            return ql;
        }
        return null;
    }

    public QueryLanguage(String name2) {
        assert (name2 != null) : "name must not be null";
        this.name = name2;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasName(String name2) {
        return this.name.equalsIgnoreCase(name2);
    }

    public boolean equals(Object other) {
        if (other instanceof QueryLanguage) {
            QueryLanguage o = (QueryLanguage)other;
            return this.hasName(o.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().toUpperCase(Locale.ENGLISH).hashCode();
    }

    public String toString() {
        return this.getName();
    }

    static {
        QueryLanguage.register(SERQL);
        QueryLanguage.register(SPARQL);
        QueryLanguage.register(SERQO);
    }
}

