/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.io;

import java.util.BitSet;

public class ByteArrayUtil {
    public static void put(byte[] source2, byte[] target, int offset) {
        System.arraycopy(source2, 0, target, offset, source2.length);
    }

    public static byte[] get(byte[] array2, int offset) {
        return ByteArrayUtil.get(array2, offset, array2.length - offset);
    }

    public static byte[] get(byte[] array2, int offset, int length) {
        byte[] result = new byte[length];
        System.arraycopy(array2, offset, result, 0, length);
        return result;
    }

    public static void putInt(int value, byte[] array2, int offset) {
        array2[offset] = (byte)(0xFF & value >>> 24);
        array2[offset + 1] = (byte)(0xFF & value >>> 16);
        array2[offset + 2] = (byte)(0xFF & value >>> 8);
        array2[offset + 3] = (byte)(0xFF & value);
    }

    public static int getInt(byte[] array2, int offset) {
        return (array2[offset] & 0xFF) << 24 | (array2[offset + 1] & 0xFF) << 16 | (array2[offset + 2] & 0xFF) << 8 | array2[offset + 3] & 0xFF;
    }

    public static void putLong(long value, byte[] array2, int offset) {
        array2[offset] = (byte)(0xFFL & value >>> 56);
        array2[offset + 1] = (byte)(0xFFL & value >>> 48);
        array2[offset + 2] = (byte)(0xFFL & value >>> 40);
        array2[offset + 3] = (byte)(0xFFL & value >>> 32);
        array2[offset + 4] = (byte)(0xFFL & value >>> 24);
        array2[offset + 5] = (byte)(0xFFL & value >>> 16);
        array2[offset + 6] = (byte)(0xFFL & value >>> 8);
        array2[offset + 7] = (byte)(0xFFL & value);
    }

    public static long getLong(byte[] array2, int offset) {
        return (long)(array2[offset] & 0xFF) << 56 | (long)(array2[offset + 1] & 0xFF) << 48 | (long)(array2[offset + 2] & 0xFF) << 40 | (long)(array2[offset + 3] & 0xFF) << 32 | (long)(array2[offset + 4] & 0xFF) << 24 | (long)(array2[offset + 5] & 0xFF) << 16 | (long)(array2[offset + 6] & 0xFF) << 8 | (long)(array2[offset + 7] & 0xFF);
    }

    public static int find(byte[] a, int fromIndex, int toIndex, byte key2) {
        int result = -1;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        toIndex = Math.min(toIndex, a.length);
        for (int i = fromIndex; fromIndex < toIndex && result == -1 && i < toIndex; ++i) {
            if (a[i] != key2) continue;
            result = i;
        }
        return result;
    }

    public static int find(byte[] a, int fromIndex, int toIndex, byte[] key2) {
        int result = -1;
        int sublen = key2.length;
        int sp = 0;
        int maxpos = Math.min(toIndex, a.length) - sublen;
        int first = fromIndex;
        while (sp != sublen && first <= maxpos && (first = ByteArrayUtil.find(a, first, maxpos, key2[0])) >= 0 && first <= maxpos) {
            for (sp = 1; sp < sublen; ++sp) {
                if (a[first + sp] == key2[sp]) continue;
                sp = sublen;
            }
            ++first;
        }
        if (sublen == 0) {
            result = 0;
        } else if (sp == sublen) {
            result = first - 1;
        }
        return result;
    }

    public static boolean matchesPattern(byte[] value, byte[] mask, byte[] pattern) {
        for (int i = 0; i < value.length; ++i) {
            if (((value[i] ^ pattern[i]) & mask[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(byte[] subValue, byte[] superValue, int offset) {
        for (int i = 0; i < subValue.length; ++i) {
            if (subValue[i] == superValue[i + offset]) continue;
            return false;
        }
        return true;
    }

    public static int compareRegion(byte[] array1, int startIdx1, byte[] array2, int startIdx2, int length) {
        int result = 0;
        for (int i = 0; result == 0 && i < length; ++i) {
            result = (array1[startIdx1 + i] & 0xFF) - (array2[startIdx2 + i] & 0xFF);
        }
        return result;
    }

    public static BitSet toBitSet(byte[] array2) {
        BitSet bitSet = new BitSet(8 * array2.length);
        for (int byteNo = 0; byteNo < array2.length; ++byteNo) {
            byte b = array2[byteNo];
            for (int bitNo = 0; bitNo < 8; ++bitNo) {
                if ((b & ByteArrayUtil.byteMask(bitNo)) == 0) continue;
                bitSet.set(8 * byteNo + bitNo);
            }
        }
        return bitSet;
    }

    public static byte[] toByteArray(BitSet bitSet) {
        byte[] array2 = new byte[bitSet.size() / 8 + 1];
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            int n = i / 8;
            array2[n] = (byte)(array2[n] | ByteArrayUtil.byteMask(i));
            i = bitSet.nextSetBit(i + 1);
        }
        return array2;
    }

    private static byte byteMask(int bitNo) {
        return (byte)(128 >>> bitNo % 8);
    }

    public static String toHexString(byte[] array2) {
        StringBuilder sb = new StringBuilder(2 * array2.length);
        for (int i = 0; i < array2.length; ++i) {
            String hex = Integer.toHexString(array2[i] & 0xFF);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }
}

