/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.IOUtils;

public class NRTCachingDirectory
extends FilterDirectory
implements Accountable {
    private final RAMDirectory cache = new RAMDirectory();
    private final long maxMergeSizeBytes;
    private final long maxCachedBytes;
    private static final boolean VERBOSE = false;
    private final Object uncacheLock = new Object();

    public NRTCachingDirectory(Directory delegate, double maxMergeSizeMB, double maxCachedMB) {
        super(delegate);
        this.maxMergeSizeBytes = (long)(maxMergeSizeMB * 1024.0 * 1024.0);
        this.maxCachedBytes = (long)(maxCachedMB * 1024.0 * 1024.0);
    }

    @Override
    public String toString() {
        return "NRTCachingDirectory(" + this.in + "; maxCacheMB=" + (double)(this.maxCachedBytes / 1024L) / 1024.0 + " maxMergeSizeMB=" + (double)(this.maxMergeSizeBytes / 1024L) / 1024.0 + ")";
    }

    @Override
    public synchronized String[] listAll() throws IOException {
        HashSet<String> files = new HashSet<String>();
        for (String f : this.cache.listAll()) {
            files.add(f);
        }
        for (String f : this.in.listAll()) {
            if (files.add(f)) continue;
            throw new IllegalStateException("file: " + this.in + " appears both in delegate and in cache: " + "cache=" + Arrays.toString(this.cache.listAll()) + ",delegate=" + Arrays.toString(this.in.listAll()));
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public synchronized void deleteFile(String name2) throws IOException {
        if (this.cache.fileNameExists(name2)) {
            this.cache.deleteFile(name2);
        } else {
            this.in.deleteFile(name2);
        }
    }

    @Override
    public synchronized long fileLength(String name2) throws IOException {
        if (this.cache.fileNameExists(name2)) {
            return this.cache.fileLength(name2);
        }
        return this.in.fileLength(name2);
    }

    public String[] listCachedFiles() {
        return this.cache.listAll();
    }

    @Override
    public IndexOutput createOutput(String name2, IOContext context) throws IOException {
        if (this.doCacheWrite(name2, context)) {
            try {
                this.in.deleteFile(name2);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return this.cache.createOutput(name2, context);
        }
        try {
            this.cache.deleteFile(name2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.in.createOutput(name2, context);
    }

    @Override
    public void sync(Collection<String> fileNames) throws IOException {
        for (String fileName : fileNames) {
            this.unCache(fileName);
        }
        this.in.sync(fileNames);
    }

    @Override
    public void renameFile(String source2, String dest) throws IOException {
        this.unCache(source2);
        this.in.renameFile(source2, dest);
    }

    @Override
    public synchronized IndexInput openInput(String name2, IOContext context) throws IOException {
        if (this.cache.fileNameExists(name2)) {
            return this.cache.openInput(name2, context);
        }
        return this.in.openInput(name2, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.cache.isOpen) {
                        for (String fileName : this.cache.listAll()) {
                            this.unCache(fileName);
                        }
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.cache, this.in);
                    } else {
                        IOUtils.closeWhileHandlingException(this.cache, this.in);
                    }
                    throw throwable;
                }
                IOUtils.close(this.cache, this.in);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.cache, this.in);
        }
    }

    protected boolean doCacheWrite(String name2, IOContext context) {
        long bytes2 = 0L;
        if (context.mergeInfo != null) {
            bytes2 = context.mergeInfo.estimatedMergeBytes;
        } else if (context.flushInfo != null) {
            bytes2 = context.flushInfo.estimatedSegmentSize;
        }
        return bytes2 <= this.maxMergeSizeBytes && bytes2 + this.cache.ramBytesUsed() <= this.maxCachedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unCache(String fileName) throws IOException {
        Object object = this.uncacheLock;
        synchronized (object) {
            if (!this.cache.fileNameExists(fileName)) {
                return;
            }
            IOContext context = IOContext.DEFAULT;
            IndexOutput out = this.in.createOutput(fileName, context);
            IndexInput in = null;
            try {
                in = this.cache.openInput(fileName, context);
                out.copyBytes(in, in.length());
            }
            catch (Throwable throwable) {
                IOUtils.close(in, out);
                throw throwable;
            }
            IOUtils.close(in, out);
            NRTCachingDirectory nRTCachingDirectory = this;
            synchronized (nRTCachingDirectory) {
                this.cache.deleteFile(fileName);
            }
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.cache.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.singleton(Accountables.namedAccountable("cache", this.cache));
    }
}

