/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBox;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoDegenerateHorizontalLine;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoDegenerateLatitudeZone;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoDegenerateLongitudeSlice;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoDegeneratePoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoDegenerateVerticalLine;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoLatitudeZone;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoLongitudeSlice;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoNorthLatitudeZone;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoNorthRectangle;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoRectangle;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoSouthLatitudeZone;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoSouthRectangle;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoWideDegenerateHorizontalLine;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoWideLongitudeSlice;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoWideNorthRectangle;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoWideRectangle;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoWideSouthRectangle;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoWorld;

public class GeoBBoxFactory {
    private GeoBBoxFactory() {
    }

    public static GeoBBox makeGeoBBox(double topLat, double bottomLat, double leftLon, double rightLon) {
        if (topLat > 1.5707963267948966) {
            topLat = 1.5707963267948966;
        }
        if (bottomLat < -1.5707963267948966) {
            bottomLat = -1.5707963267948966;
        }
        if (leftLon < -Math.PI) {
            leftLon = -Math.PI;
        }
        if (rightLon > Math.PI) {
            rightLon = Math.PI;
        }
        if (Math.abs(leftLon + Math.PI) < 1.0E-12 && Math.abs(rightLon - Math.PI) < 1.0E-12) {
            if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12 && Math.abs(bottomLat + 1.5707963267948966) < 1.0E-12) {
                return new GeoWorld();
            }
            if (Math.abs(topLat - bottomLat) < 1.0E-12) {
                if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12 || Math.abs(topLat + 1.5707963267948966) < 1.0E-12) {
                    return new GeoDegeneratePoint(topLat, 0.0);
                }
                return new GeoDegenerateLatitudeZone(topLat);
            }
            if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12) {
                return new GeoNorthLatitudeZone(bottomLat);
            }
            if (Math.abs(bottomLat + 1.5707963267948966) < 1.0E-12) {
                return new GeoSouthLatitudeZone(topLat);
            }
            return new GeoLatitudeZone(topLat, bottomLat);
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (topLat == 1.5707963267948966 && bottomLat == -1.5707963267948966) {
            if (Math.abs(leftLon - rightLon) < 1.0E-12) {
                return new GeoDegenerateLongitudeSlice(leftLon);
            }
            if (extent >= Math.PI) {
                return new GeoWideLongitudeSlice(leftLon, rightLon);
            }
            return new GeoLongitudeSlice(leftLon, rightLon);
        }
        if (Math.abs(leftLon - rightLon) < 1.0E-12) {
            if (Math.abs(topLat - bottomLat) < 1.0E-12) {
                return new GeoDegeneratePoint(topLat, leftLon);
            }
            return new GeoDegenerateVerticalLine(topLat, bottomLat, leftLon);
        }
        if (extent >= Math.PI) {
            if (Math.abs(topLat - bottomLat) < 1.0E-12) {
                return new GeoWideDegenerateHorizontalLine(topLat, leftLon, rightLon);
            }
            if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12) {
                return new GeoWideNorthRectangle(bottomLat, leftLon, rightLon);
            }
            if (Math.abs(bottomLat + 1.5707963267948966) < 1.0E-12) {
                return new GeoWideSouthRectangle(topLat, leftLon, rightLon);
            }
            return new GeoWideRectangle(topLat, bottomLat, leftLon, rightLon);
        }
        if (Math.abs(topLat - bottomLat) < 1.0E-12) {
            if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12 || Math.abs(topLat + 1.5707963267948966) < 1.0E-12) {
                return new GeoDegeneratePoint(topLat, 0.0);
            }
            return new GeoDegenerateHorizontalLine(topLat, leftLon, rightLon);
        }
        if (Math.abs(topLat - 1.5707963267948966) < 1.0E-12) {
            return new GeoNorthRectangle(bottomLat, leftLon, rightLon);
        }
        if (Math.abs(bottomLat + 1.5707963267948966) < 1.0E-12) {
            return new GeoSouthRectangle(topLat, leftLon, rightLon);
        }
        return new GeoRectangle(topLat, bottomLat, leftLon, rightLon);
    }
}

