/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.spatial.prefix.AbstractVisitingPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public class IntersectsPrefixTreeFilter
extends AbstractVisitingPrefixTreeFilter {
    public IntersectsPrefixTreeFilter(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel) {
        super(queryShape, fieldName, grid, detailLevel, prefixGridScanLevel);
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        return new AbstractVisitingPrefixTreeFilter.VisitorTemplate(context, acceptDocs){
            private FixedBitSet results;

            @Override
            protected void start() {
                this.results = new FixedBitSet(this.maxDoc);
            }

            @Override
            protected DocIdSet finish() {
                return new BitDocIdSet(this.results);
            }

            @Override
            protected boolean visitPrefix(Cell cell) throws IOException {
                if (cell.getShapeRel() == SpatialRelation.WITHIN || cell.getLevel() == IntersectsPrefixTreeFilter.this.detailLevel) {
                    this.collectDocs(this.results);
                    return false;
                }
                return true;
            }

            @Override
            protected void visitLeaf(Cell cell) throws IOException {
                this.collectDocs(this.results);
            }
        }.getDocIdSet();
    }

    @Override
    public String toString(String field) {
        return "IntersectsPrefixTreeFilter(fieldName=" + this.fieldName + "," + "queryShape=" + this.queryShape + "," + "detailLevel=" + this.detailLevel + "," + "prefixGridScanLevel=" + this.prefixGridScanLevel + ")";
    }
}

